package be.cytomine.utils

class UrlMappings {

    static mappings = {
        group("/api") {
            group("/attachedfile") {
                ".$format"(controller: "attachedFile", action: [GET: "list", POST: "upload", PUT: "upload"])
                "/$id.$format"(controller: "attachedFile", action: [GET: "show"])
                "/$id/download"(controller: "attachedFile", action: [GET: "download"])

                // FOR JS
                "RTEditor.$format"(controller: "attachedFile", action: [POST: "uploadFromRTEditor"])
            }
            "/domain/$domainClassName/$domainIdent/attachedfile.$format"(controller: "attachedFile",
                    action: [GET: "listByDomain"])
            
            group("/description") {
                ".$format"(controller: "description", action: [GET: "list", POST: "add"])
            }
            "/domain/$domainClassName/$domainIdent/description.$format"(controller: "description",
                    action: [GET: "showByDomain", POST: "add", PUT: "update", DELETE: "delete"])

            group("/configuration") {
                ".$format"(controller: "configuration", action: [GET: "list", POST: "add"])
                "/key/$key.$format"(controller: "configuration", action: [GET: "show", PUT: "update", DELETE: "delete"])
            }

            group("/task") {
                ".$format"(controller: "task", action: [POST: "add"])
                "/$id.$format"(controller: "task", action: [GET: "show"])
            }
            "/project/$idProject/task/comment.$format"(controller: "task", action: [GET: "listCommentByProject"])

            "/news.$format"(controller: "news", action: [GET: "listNews"])
        }

        "/ldap.$format"(controller: "configuration", action: [GET: "ldap"])
    }
}