package be.cytomine.utils

import be.cytomine.RestController

/*
* Copyright (c) 2009-2017. Authors: see NOTICE file.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
import grails.converters.JSON
import grails.converters.XML
import rest.api.doc.annotation.RestApiMethod
import rest.api.doc.annotation.RestApiParam
import rest.api.doc.annotation.RestApiParams
import rest.api.doc.pojo.RestApiParamType

class ConfigurationController extends RestController {

    def configurationService

    @RestApiMethod(description="Get all global configs")
    def list() {
        def data = configurationService.list()
        responseSuccess(data)
    }

    @RestApiMethod(description="Get a config with its id or its key")
    @RestApiParams(params=[
            @RestApiParam(name="key", type="String", paramType = RestApiParamType.PATH,description = "The config key")
    ])
    def show() {
        Configuration config = configurationService.readByKey(params.key)

        if (config) {
            responseSuccess(config)
        } else {
            responseNotFound("Configuration", params.key)
        }
    }

    @RestApiMethod(description="Add a global config")
    def add() {
        add(configurationService, request.JSON)
    }


    @RestApiMethod(description="Edit a config")
    def update() {
        Configuration config = configurationService.readByKey(params.key)

        if (config) {
            request.JSON.id = config.id
            configurationService.update(config, request.JSON)
            update(configurationService, request.JSON)
        } else {
            add(configurationService, request.JSON)
        }
    }

    /**
     * Delete a Property (Method from RestController)
     */
    @RestApiMethod(description="Delete a config")
    @RestApiParams(params=[
            @RestApiParam(name="id", type="long", paramType = RestApiParamType.PATH,description = "The config id")
    ])
    def delete()  {
        Configuration config = configurationService.readByKey(params.key)
        def result = configurationService.delete(config)
        responseResult(result)
    }

    @RestApiMethod(description="Get the boolean LDAP enabled")
    def ldap() {

        def data = [:]
        data['enabled'] = grailsApplication.config.grails.plugin.springsecurity.ldap.active

        withFormat {
            json { render data as JSON }
            xml { render data as XML}
        }
    }

}
