package be.cytomine.stats

class UrlMappings {

    static mappings = {
        group("/api") {
            group("/project/$id/stats") {
                "/term.$format"(controller: "stats", action: [GET: "statTerm"])
                "/user.$format"(controller: "stats", action: [GET: "statUser"])
                "/termslide.$format"(controller: "stats", action: [GET: "statTermSlide"])
                "/userslide.$format"(controller: "stats", action: [GET: "statUserSlide"])
                "/userannotations.$format"(controller: "stats", action: [GET: "statUserAnnotations"])
                "/annotationevolution.$format"(controller: "stats", action: [GET: "statAnnotationEvolution"])
            }

            "/term/$id/project/stat.$format"(controller:"stats", action: [GET:"statAnnotationTermedByProject"])

            group("/total") {
                "/project/connections.$format"(controller: "stats", action: [GET:"totalNumberOfConnectionsByProject"])
                "$domain.$format"(controller:"stats", action: [GET:"totalDomains"])
            }

            group("/stats") {
                "/imageserver/total.$format"(controller:"stats", action: [GET:"statUsedStorage"])
                "/all.$format"(controller:"stats", action: [GET:"allGlobalStats"])
                "/currentStats.$format"(controller:"stats", action: [GET:"statsOfCurrentActions"])

                group("/retrieval") {
                    group("-evolution") {
                        "/evolution.$format"(controller:"retrievalEvolutionStats", action:
                                [GET:"statRetrievalEvolution"])
                        "/evolutionByTerm.$format"(controller:"retrievalEvolutionStats", action:
                                [GET:"statRetrievalEvolutionByTerm"])
                    }

                    "/avg.$format"(controller:"retrievalSuggestStats", action: [GET:"statRetrievalAVG"])
                    "/confusionmatrix.$format"(controller:"retrievalSuggestStats",
                            action: [GET:"statRetrievalConfusionMatrix"])
                    "/worstTerm.$format"(controller:"retrievalSuggestStats", action: [GET:"statRetrievalWorstTerm"])
                    "/worstTermWithSuggest.$format"(controller:"retrievalSuggestStats",
                            action: [GET:"statWorstTermWithSuggestedTerm"])
                    "/worstAnnotation.$format"(controller:"retrievalSuggestStats",
                            action: [GET:"statRetrievalWorstAnnotation"])
                    "/evolution.$format"(controller:"retrievalSuggestStats",action: [GET:"statRetrievalEvolution"])
                }
            }
        }
    }
}