package be.cytomine.social

class UrlMappings {

    static mappings = {
        group("/api") {
            /**
             * ANNOTATION ACTION
             */
            "/annotationaction.$format"(controller: "annotationAction", action: [POST:"add"])
            "/imageinstance/$image/annotationactions.$format" (controller : "annotationAction", action: [GET:"list"])

            /**
             * IMAGE CONSULTATION
             */
            "/imageinstance/$id/consultation.$format" (controller : "imageConsultation", action: [POST:"add"])
            "/project/$project/lastImages.$format"(controller:"imageConsultation", action: [GET : "lastImageOfUsersByProject"])
            "/imageconsultation/resume.$format" (controller:"imageConsultation", action: [GET : "resumeByUserAndProject"])

            /**
             * PROJECT CONNECTION
             */
            "/project/$project/userconnection.$format"(controller: "projectConnection", action: [POST: "add"])
            "/project/$project/userconnection/$user.$format"(controller: "projectConnection",
                    action: [GET: "getConnectionByUserAndProject"])
            "/project/$project/lastConnection.$format"(controller: "projectConnection",
                    action: [GET: "lastConnectionInProject"])
            "/project/$project/lastConnection/$user.$format"(controller: "projectConnection",
                    action: [GET: "lastConnectionInProjectByUser"])
            "/project/$project/connectionFrequency.$format"(controller: "projectConnection",
                    action: [GET: "numberOfConnectionsByProject"])
            "/project/$project/connectionFrequency/$user.$format"(controller: "projectConnection",
                    action: [GET: "numberOfConnectionsByProjectAndUser"])
            "/project/$project/connectionHistory/$user.$format"(controller: "projectConnection",
                    action: [GET: "userProjectConnectionHistory"])
            "/projectConnection/$id.$format"(controller: "projectConnection", action: [GET: "getUserActivityDetails"])
            "/connectionFrequency.$format"(controller: "projectConnection", action: [GET: "numberOfProjectConnections"])
            "/averageConnections.$format"(controller: "projectConnection", action: [GET: "averageOfProjectConnections"])

            /**
             * USER POSITION
             */
            "/imageinstance/$id/position.$format" (controller : "userPosition", action: [POST:"add"])
            "/imageinstance/$id/position/$user.$format" (controller : "userPosition", action: [GET:"lastPositionByUser"])
            "/imageinstance/$image/positions.$format" (controller : "userPosition", action: [GET:"list"])
            "/imageinstance/$id/online.$format"(controller: "userPosition", action: [GET:"listOnlineUsersByImage"])
        }
    }
}