package be.cytomine.security.interceptors


class RequestInterceptor {
    def springSecurityService

    RequestInterceptor() {
        matchAll()
    }

    boolean before() {
        if (!(actionName == "crop" || actionName == "ping" || actionName == "listOnlineFriendsWithPosition" ||
                actionName == "listOnlineUsersByImage" || (controllerName == "annotationIndex" && actionName ==
                "listByImage") || (controllerName == "userPosition" && actionName == "add"))) {
            request.currentTime = System.currentTimeMillis()
            String userInfo
            try {
                userInfo = springSecurityService.principal.id
            } catch (MissingPropertyException e) {
                userInfo = springSecurityService.principal
            }
            log.info controllerName + "." + actionName + ": user:" + userInfo
        }

        true
    }

    boolean after() { true }

    void afterView() {
        if (!(actionName == "crop" || actionName == "ping" || actionName == "listOnlineFriendsWithPosition" ||
                actionName == "listOnlineUsersByImage" || (controllerName == "annotationIndex" && actionName ==
                "listByImage") || (controllerName == "userPosition" && actionName == "add"))) {
            log.info controllerName + "." + actionName + " Request took ${System.currentTimeMillis() - request.currentTime}ms"
        }
    }
}
