package be.cytomine.security.interceptors

import be.cytomine.security.AuthWithToken
import be.cytomine.security.SecUser
import be.cytomine.security.User
import be.cytomine.utils.SecurityUtils
import grails.plugin.springsecurity.SpringSecurityUtils

import javax.servlet.Filter
import javax.servlet.FilterChain
import javax.servlet.FilterConfig
import javax.servlet.ServletRequest
import javax.servlet.ServletResponse
import javax.servlet.http.HttpServletResponse


class ApiAuthenticationFilter implements Filter {

    boolean before() { true }

    boolean after() { true }

    void afterView() {
        // no-op
    }

    @Override
    void init(FilterConfig filterConfig) {

    }

    @Override
    void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
        //log with token id
        boolean token = tryAPIAUhtenticationWithToken(request, response)
        if(!token) {
            //with signature (in header)
            tryAPIAuthentication(request, response)
        }

        chain.doFilter(request, response)
    }

    @Override
    void destroy() {

    }

    /**
     * http://code.google.com/apis/storage/docs/reference/v1/developer-guidev1.html#authentication
     */
    private static boolean tryAPIAuthentication(def request, def response) {
        if (request.getHeader("date") == null) {
            return false
        }
        if (request.getHeader("host") == null) {
            return false
        }
        String authorization = request.getHeader("authorization")
        if (authorization == null) {
            return false
        }
        if (!authorization.startsWith("CYTOMINE") || !authorization.indexOf(" ") == -1 || !authorization.indexOf(":") == -1) {
            return false
        }
        try {

            String content_md5 = (request.getHeader("content-MD5") != null) ? request.getHeader("content-MD5") : ""
            String content_type = (request.getHeader("content-type") != null) ? request.getHeader("content-type") : ""
            content_type = (request.getHeader("Content-Type") != null) ? request.getHeader("Content-Type") : content_type
            String date = (request.getHeader("date") != null) ? request.getHeader("date") : ""

            String queryString = (request.getQueryString() != null) ? "?" + request.getQueryString() : ""

            String path = request.forwardURI //original URI Request

            String accessKey = authorization.substring(authorization.indexOf(" ") + 1, authorization.indexOf(":"))
            String authorizationSign = authorization.substring(authorization.indexOf(":") + 1)
            SecUser user
            SecUser.withTransaction {
                user = SecUser.findByPublicKeyAndEnabled(accessKey,true)
            }


            if (!user) {
                response.sendError(HttpServletResponse.SC_UNAUTHORIZED, "Unauthorized");
                return false
            }

            String signature = SecurityUtils.generateKeys(request.getMethod(),content_md5, content_type,date,
                    queryString,path,user)
            if (authorizationSign == signature) {
                SpringSecurityUtils.reauthenticate user.getUsername(), null
                return true
            } else {
                return false
            }

        } catch (Exception e) {
            e.printStackTrace()
            return false
        }
    }

    private static boolean tryAPIAUhtenticationWithToken(ServletRequest request, ServletResponse response) {
        String tokenKey = request.getParameter("tokenKey");

        if(tokenKey!=null) {
            String username = request.getParameter("username")
            User user = User.findByUsername(username) //we are not logged, we bypass the service
            AuthWithToken authToken = AuthWithToken.findByTokenKeyAndUser(tokenKey, user)
            //check first if a entry is made for this token
            if (authToken && authToken.isValid())  {
                SpringSecurityUtils.reauthenticate user.username, null
                return true
            } else {
                return false
            }
        } else {
            return false
        }
    }
}
