package be.cytomine.security

class UrlMappings {

    static mappings = {
        group("/api") {
            group("/user") {
                ".$format"(controller: "user", action: [GET:"list",POST:"add"])
                "/$id.$format"(controller: "user", action: [GET:"show",PUT:"update", DELETE:"delete"])
                "/current.$format"(controller: "user", action: [GET: "showCurrent"])
                "/invitation.$format"(controller: "user", action: [POST: "inviteNewUser"])
                "/$id/firends.$format"(controller: "user", action: [GET: "listFriends"])
                "/$id/keys.$format"(controller: "user", action: [GET: "keys"])
                "/$id/password.$format"(controller: "user", action: [PUT: "resetPassword"])
            }
            "/group/$id/user.$format"(controller: "user", action: [GET: "listByGroup"])

            group("/userJob") {
                ".$format"(controller: "userJob", action: [POST: "createUserJob"])
                "/$id.$format"(controller: "userJob", action: [GET:"showUserJob", PUT: "update"])
            }

            group("/project") {
                "/$id/user.$format"(controller: "user", action: [GET: "showByProject", POST: "addUser"])
                "/$id/admin.$format"(controller: "user", action: [GET: "showAdminByProject"])
                "/$id/users/representative.$format"(controller: "user", action: [GET: "showRepresentativeByProject"])
                "/$id/creator.$format"(controller: "user", action: [GET: "showCreatorByProject"])
                "/$id/user/$idUser.$format"(controller: "user", action: [DELETE: "deleteUserFromProject", POST: "addUserToProject"])
                "/$id/user/$idUser/admin.$format"(controller: "user", action: [DELETE: "deleteUserAdminFromProject", POST: "addUserAdminToProject"])

                "/$id/userlayer.$format"(controller: "user", action: [GET:"showLayerByProject"])
                "/$id/online/user.$format"(controller: "user", action: [GET:"listOnlineFriendsWithPosition"])
                "/$id/usersActivity.$format"(controller: "user", action: [GET:"listUsersWithLastActivity"])
                "/$id/user/download"(controller: "user", action: [GET:"downloadUserListingLightByProject"])
                "/$project/resumeActivity/$user.$format"(controller: "user", action: [GET:"resumeUserActivity"])

                "/$id/userjob.$format"(controller: "userJob", action: [GET: "listUserJobByProject"])
            }

            group("/ontology") {
                "/$id/user.$format"(controller: "user", action: [GET:"showUserByOntology"])
                "/$id/creator.$format"(controller: "user", action: [GET:"showCreatorByOntology"])
            }

            group("/ldap") {
                "/user.$format"(controller: "user", action: [POST:"addFromLDAP"])
                "/$username/user.$format"(controller: "user", action: [GET:"isInLdap"])

                "/group.$format"(controller: "group", action: [POST: "createFromLDAP"])
                "/$id/group.$format"(controller: "group", action: [GET: "isInLDAP", PUT: "resetFromLDAP"])
            }

            "/domain/$domainClassName/$domainIdent/user/$user.$format"(controller:"restACL",
                    action: [GET:"list", POST:"add", DELETE: "delete"])
            "/acl.$format"(controller:"restACL", action: [GET:"listACL"])
            "/acl/domain.$format"(controller:"restACL", action: [GET:"listDomain"])

            "/signature.$format"(controller: "user", action: [GET: "signature"])
            "/userkey/$publicKey/keys.$format"(controller: "user", action: [GET: "keys"])
            "/token.$format"(controller: "login", action: [GET:"buildToken",POST:"buildToken"])


            group("/group") {
                ".$format"(controller: "group", action: [GET:"list", POST:"add"])
                "/$id.$format"(controller: "group", action: [GET:"show", PUT:"update", DELETE:"delete"])
            }
            "/image/$idabstractimage/group.$format"(controller:"restGroup", action: [GET: "listGroupByAbstractImage"])

            group("/user/$user/group") {
                ".$format"(controller: "userGroup", action: [GET:"list", POST: "add"])
                "/$group.$format"(controller: "userGroup", action: [GET:"show",  DELETE:"delete"])
            }

            group("/role") {
                ".$format"(controller: "secRole", action: [GET:"list"])
                "/$id.$format"(controller: "secRole", action: [GET:"show"])
            }

            group("/user/$user/role") {
                ".$format"(controller: "secUserSecRole", action: [GET:"list", POST:"add"])
                "/$role.$format"(controller: "secUserSecRole", action: [GET:"show", DELETE:"delete"])
                "/$role/define.$format"(controller: "secUserSecRole", action: [PUT:"define"])
            }
        }

        group("/session/admin") {
            "/open.$format"(controller: "grantRole", action: [GET: "openAdminSession"])
            "/close.$format"(controller: "grantRole", action: [GET: "closeAdminSession"])
            "/info.$format"(controller: "grantRole", action: [GET: "infoAdminSession"])
        }

        "/loginWithoutLDAP/login" (controller: "login",action: [GET:"loginWithoutLDAP"])
        "/login/forgotPassword" (controller: "login",action: [POST:"forgotPassword"])
        "/login/loginWithToken" (controller: "login", action: [GET:"loginWithToken"])
        "/login/loginWithLTI" (controller: "login", action: [POST:"loginWithLTI"])

        "/status.$format"(controller: "server", action: "status")
    }
}
