package be.cytomine.search

class UrlMappings {

    static mappings = {
        group("/api") {
            group("/search") {
                ".$format"(controller: "search", action: [GET:"listResponse"])
            }

            "/search-engine.$format"(controller: "searchEngine", action:[GET:"search"])
            "/search-result.$format"(controller: "searchEngine", action:[GET:"result"])
            "/image/$className/$id.$format"(controller:"searchEngine", action:[GET:"redirectToImageURL"])
            "/url/$className/$id.$format"(controller:"searchEngine", action:[GET:"redirectToGoToURL"])

            group("/searchenginefilter") {
                ".$format"(controller: "searchEngineFilter", action: [GET:"list", POST:"add"])
                "/$id.$format"(controller: "searchEngineFilter", action: [GET:"show", DELETE:"delete"])
            }
        }
    }
}