package be.cytomine.project

class UrlMappings {

    static mappings = {
        group("/api") {
            //Discipline
            group("/discipline") {
                ".$format"(controller: "discipline", action: [GET:"list", POST:"add"])
                "/$id.$format"(controller: "discipline", action: [GET:"show", PUT:"update", DELETE:"delete"])
            }

            // Project
            group("/project") {
                ".$format"(controller: "project", action: [GET:"list", POST:"add"])
                "/$id.$format"(controller: "project", action: [GET:"show", PUT:"update", DELETE:"delete"])
                "/$id/last/$max.$format"(controller: "project", action: [GET:"lastAction"])
                "/method/lastopened.$format"(controller: "project", action: [GET: "listLastOpened"])
                "/$id/invitation.$format"(controller: "project", action: [POST: "inviteNewUser"])
            }
            "/software/$id/project.$format"(controller: "project", action: [GET: "listBySoftware"])
            "/ontology/$id/project.$format"(controller: "project", action: [GET: "listByOntology"])
            "/retrieval/$id/project.$format"(controller: "project", action: [GET: "listRetrieval"])
            "/user/$id/project.$format"(controller: "project", action: [GET: "listByUser"])
            "/user/$id/project/light.$format"(controller: "project", action: [GET: "listLightByUser"])

            "/commandhistory.$format"(controller: "project", action: [GET: "listCommandHistory"])
            "/project/$id/commandhistory.$format"(controller: "project", action: [GET: "listCommandHistory"])


            // Project default layer
            "/project/$idProject/defaultlayer.$format"(controller: "projectDefaultLayer",
                    action: [GET: "listByProject",POST:"add"])
            "/project/$idProject/defaultlayer/$id.$format"(controller: "projectDefaultLayer",
                    action: [GET:"show",PUT:"update", DELETE:"delete"])

            // Project representative user
            "/project/$idProject/representative.$format"(controller: "projectRepresentativeUser",
                    action: [GET: "listByProject",POST:"add"])
            "project/$idProject/representative/$id.$format"(controller: "projectRepresentativeUser",
                    action: [GET:"show", PUT:"update", DELETE:"delete"])
        }
    }
}