package be.cytomine.processing

class UrlMappings {

    static mappings = {
        group("/api") {
            group("/software") {
                ".$format"(controller:"software", action: [GET: "list",POST:"add"])
                "/$id.$format"(controller:"software", action: [GET:"show",PUT:"update", DELETE:"delete"])
            }
            "/project/$id/software.$format"(controller:"software", action: [GET: "listByProject"])

            group("/softwareparameter") {
                ".$format"(controller:"softwareParameter", action: [GET: "list",POST:"add"])
                "/$id.$format"(controller:"softwareParameter", action: [GET:"show",PUT:"update", DELETE:"delete"])
            }
            "/software/$id/parameter.$format"(controller:"softwareParameter", action: [GET: "listBySoftware"])

            group("/softwareproject") {
                ".$format"(controller:"softwareProject", action: [GET: "list",POST:"add"])
                "/$id.$format"(controller:"softwareProject", action: [GET:"show", DELETE:"delete"])
            }
            "/project/$id/softwareproject.$format"(controller:"softwareProject", action: [GET: "listByProject"])
            "/project/$idProject/software/$idSoftware/stats.$format"(controller:"software", action: [GET: "softwareInfoForProject"])

            group("/job") {
                ".$fomat"(controller:"job", action: [GET: "list",POST:"add"])
                "/$id.$format"(controller:"job", action: [GET:"show",PUT:"update", DELETE:"delete"])
                "/$id/alldata.$format"(controller:"job", action: [DELETE: "deleteAllJobData", GET: "listAllJobData"])
                "/$id/execute.$format" (controller : "job", action: [POST : "execute"])
                "/$id/preview_roi.$format" (controller : "job", action: [GET : "getPreviewRoi"])
                "/$id/preview.$format" (controller : "job", action: [POST : "preview", GET : "getPreview"])
            }
            "/project/$id/job/purge.$format"(controller : "job", action: [POST : "purgeJobNotReviewed", GET : "purgeJobNotReviewed"])

            group("/jobparameter") {
                ".$format"(controller:"jobParameter", action: [GET: "list",POST:"add"])
                "/$id.$format"(controller:"jobParameter", action: [GET:"show",PUT:"update", DELETE:"delete"])
            }
            "/job/$id/parameter.$format"(controller:"jobParameter", action: [GET: "listByJob"])
            
            group("/jobdata") {
                ".$format"(controller: "jobData", action: [GET:"list", POST:"add"])
                "/$id.$format"(controller: "jobData", action: [GET:"show", PUT:"update", DELETE:"delete"])
                "/$id/upload"(controller:"jobData", action: [PUT:"upload", POST: "upload"])
                "/$id/download"(controller:"jobData", action: [GET: "download"])
                "/$id/view"(controller:"jobData", action: [GET: "view"])
            }
            "/job/$id/jobdata.$format"(controller: "jobData", action: [GET:"listByJob"])
            
            group("/jobtemplate") {
                ".$fomat"(controller:"jobTemplate", action: [POST:"add"])
                "/$id.$format"(controller:"jobTemplate", action: [GET:"show",PUT:"update", DELETE:"delete"])
            }
            "/project/$project/jobtemplate.$fomat"(controller:"jobTemplate", action: [GET: "list"])
            
            group("/jobtemplateannotation") {
                ".$fomat"(controller:"jobTemplateAnnotation", action: [POST:"add",GET: "list"])
                "/$id.$format"(controller:"jobTemplateAnnotation", action: [GET:"show",PUT:"update", DELETE:"delete"])
            }

            group("/imagefilter") {
                ".$format"(controller: "imageFilter", action: [GET:"list", POST : "add"])
                "/$id.$format"(controller: "imageFilter", action: [GET:"show", DELETE : "delete"])
            }
            "/project/imagefilter.$format"(controller: "imageFilter", action: [GET:"list"])
            "/project/imagefilter/$id.$format"(controller: "imageFilter", action: [GET:"show"])
            
            group("/imagefilterproject") {
                ".$format" (controller: "imageFilterProject", action: [GET:"list", POST : "add"])
                "/$id.$format"(controller: "imageFilterProject", action: [DELETE : "delete"])
            }
            "/project/$project/imagefilterproject.$format"(controller: "imageFilterProject", action: [GET:"listByProject"])
            
            group("/processing_server") {
                ".$format"(controller: "processingServer", action: [GET:"list", POST:"add"])
                "/$id.$format"(controller: "processingServer", action: [GET:"show", DELETE: "delete"])
            }

        }
    }
}