package be.cytomine.processing

import be.cytomine.RestController

/*
* Copyright (c) 2009-2017. Authors: see NOTICE file.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
import grails.converters.JSON
import rest.api.doc.annotation.RestApi
import rest.api.doc.annotation.RestApiMethod
import rest.api.doc.annotation.RestApiParam
import rest.api.doc.annotation.RestApiParams
import rest.api.doc.pojo.RestApiParamType

/**
 * TODO:: comment this controller. Explain the "processing server goal"
 */
@RestApi(name="Processing | processing server", description="Methods to manage processing servers")
class ProcessingServerController extends RestController {

    def processingServerService

    @RestApiMethod(description="List the processing servers", listing=true)
    def list() {
        responseSuccess(processingServerService.list())
    }

    @RestApiMethod(description="Get a processing server")
    @RestApiParams(params=[
            @RestApiParam(name="id", type="long", paramType = RestApiParamType.PATH, description = "The processingServer id")
    ])
    def show() {
        ProcessingServer processingServer = processingServerService.read(params.long('id'))
        if (processingServer) {
            responseSuccess(processingServer)
        } else {
            responseNotFound("ProcessingServer", params.id)
        }
    }

    @RestApiMethod(description="Add a new processingServer to cytomine.")
    def add() {
        add(processingServerService, request.JSON)
    }

    @RestApiMethod(description="Delete a processingServer.", listing = true)
    @RestApiParams(params=[
            @RestApiParam(name="id", type="long", paramType = RestApiParamType.PATH, description = "The processingServer id")
    ])
    def delete() {
        delete(processingServerService, JSON.parse("{id : $params.id}"),null)
    }

}
