package be.cytomine.processing

import be.cytomine.exception.CytomineException

/*
* Copyright (c) 2009-2017. Authors: see NOTICE file.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
import be.cytomine.RestController
import be.cytomine.project.Project
import grails.converters.JSON
import rest.api.doc.annotation.RestApi
import rest.api.doc.annotation.RestApiMethod
import rest.api.doc.annotation.RestApiParam
import rest.api.doc.annotation.RestApiParams
import rest.api.doc.pojo.RestApiParamType

/**
 * Created by IntelliJ IDEA.
 * User: lrollus
 * Date: 18/05/11
 * Controller that handle request for project images.
 */
@RestApi(name = "Processing | job template services", description = "Methods for managing job template, a pre-filled job to quickly run")
class JobTemplateController extends RestController {

    def imageProcessingService
    def jobTemplateService
    def imageInstanceService
    def projectService
    def userAnnotationService
    def algoAnnotationService
    def reviewedAnnotationService
    def secUserService
    def termService
    def cytomineService
    def taskService
    def softwareService

    @RestApiMethod(description="Get a job template")
    @RestApiParams(params=[
        @RestApiParam(name="id", type="long", paramType = RestApiParamType.PATH, description = "The template id")
    ])
    def show() {
        JobTemplate job = jobTemplateService.read(params.long('id'))
        if (job) {
            responseSuccess(job)
        } else {
            responseNotFound("JobTemplate", params.id)
        }
    }

    @RestApiMethod(description="List template for the specific filter", listing = true)
    @RestApiParams(params=[
        @RestApiParam(name="project", type="long", paramType = RestApiParamType.PATH, description = "The projecte id"),
        @RestApiParam(name="software", type="long", paramType = RestApiParamType.QUERY, description = "(Optional) The software id"),
    ])
    def list() {
        Project project = projectService.read(params.long('project'))
        Software software = softwareService.read(params.long('software'))
        if (params.long('software') && !software)  {
            responseNotFound("JobTemplate", "Software", params.software)
        } else if (project)  {
            responseSuccess(jobTemplateService.list(project,software))
        } else {
            responseNotFound("JobTemplate", "Project", params.idImage)
        }
    }

    @RestApiMethod(description="Add a new job template")
    def add() {
        try {
            responseResult(jobTemplateService.add(request.JSON))
        } catch (CytomineException e) {
            log.error(e.toString())
            response([success: false, errors: e.msg], e.code)
        }
    }

    @RestApiMethod(description="Update a job template")
    def update() {
        update(jobTemplateService, request.JSON)
    }

    @RestApiMethod(description="Delete a job template")
    @RestApiParams(params=[
        @RestApiParam(name="id", type="long", paramType = RestApiParamType.PATH,description = "The template id")
    ])
    def delete() {
        delete(jobTemplateService, JSON.parse("{id : $params.id}"),null)
    }
}
