package be.cytomine.processing

import be.cytomine.RestController

/*
* Copyright (c) 2009-2017. Authors: see NOTICE file.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
import grails.converters.JSON
import rest.api.doc.annotation.RestApi
import rest.api.doc.annotation.RestApiMethod
import rest.api.doc.annotation.RestApiParam
import rest.api.doc.annotation.RestApiParams
import rest.api.doc.pojo.RestApiParamType

/**
 * Controller for image filter, filter that can be apply to a picture
 */
@RestApi(name = "Processing | image filter services", description = "Methods for managing image filter, filter that can be apply to a picture")
class ImageFilterController extends RestController {

    def imageFilterService

    /**
     * List all image filter
     */
    @RestApiMethod(description="List all image filter", listing = true)
    def list() {
        responseSuccess(imageFilterService.list())
    }

    /**
     * Get an image filter
     */
    @RestApiMethod(description="Get an image filter")
    @RestApiParams(params=[
        @RestApiParam(name="id", type="long", paramType = RestApiParamType.PATH, description = "The image filter id")
    ])
    def show() {
        ImageFilter imageFilter = imageFilterService.read(params.long('id'))
        if (imageFilter) {
            responseSuccess(imageFilter)
        } else {
            responseNotFound("ImageFilter", params.id)
        }
    }


    /**
     * Add a new imageFilter to cytomine
     */
    @RestApiMethod(description="Add a new imageFilter to cytomine.")
    def add() {
        add(imageFilterService, request.JSON)
    }

    /**
     * Delete imageFilter
     */
    @RestApiMethod(description="Delete an imageFilter.", listing = true)
    @RestApiParams(params=[
            @RestApiParam(name="id", type="long", paramType = RestApiParamType.PATH, description = "The imageFilter id")
    ])
    def delete() {
        delete(imageFilterService, JSON.parse("{id : $params.id}"),null)
    }
}
