package be.cytomine.ontology

class UrlMappings {

    static mappings = {
        group("/api") {
            group("/ontology") {
                ".$format"(controller: "ontology", action: [GET:"list", POST:"add"])
                "/$id.$format"(controller: "ontology", action: [GET:"show", PUT:"update", DELETE:"delete"])
                "/$id/tree.$format"(controller: "ontology", action: [GET: "tree"])
            }

            group("/term") {
                ".$format"(controller: "term", action: [GET:"list", POST:"add"])
                "/$id.$format"(controller: "term", action: [GET:"show", PUT:"update", DELETE:"delete"])
            }
            "/project/$idProject/term.$format"(controller: "term", action: [GET:"listAllByProject"])
            "/ontology/$idontology/term.$format"(controller: "term", action: [GET:"listAllByOntology"])
            
            group("/relation") {
                ".$format"(controller: "relation", action: [GET:"list", POST:"add"])
                "/$id.$format"(controller: "relation", action: [GET:"show", PUT:"update", DELETE:"delete"])

                "/$id/term.$format"(controller: "relationTerm", action: [POST:"add"])
                "/$idrelation/term1/$term1/term2/$term2.$format"(controller: "relationTerm", action: [GET: "show",DELETE:"delete"])
                "/parent/term.$format"(controller: "relationTerm", action: [POST:"add"])
                "/parent/term1/$idterm1/term2/$idterm2.$format"(controller: "relationTerm", action: [GET: "show",DELETE:"delete"])
                "/term/$id.$format"(controller: "relationTerm", action: [GET: "listByTermAll"])
                "/term/$i/$id.$format"(controller: "relationTerm", action: [GET: "listByTerm"])
            }
            
            group("/annotation/$idannotation/term") {
                ".$format"(controller:"annotationTerm", action:[GET: "listTermByAnnotation"])
                "/$idterm.$format"(controller:"annotationTerm", action:[POST:"add",DELETE:"delete", GET:"show"])
                "/$idterm/clearBefore.$format"(controller:"annotationTerm", action: [POST:"addWithDeletingOldTerm"])
                "/$idterm/user/$idUser.$format"(controller:"annotationTerm", action:[GET:"show",DELETE:"delete"])
            }
            "/annotation/$idannotation/notuser/$idNotUser/term.$format"(controller:"annotationTerm",
                    action:[GET: "listAnnotationTermByUserNot"])
            "/userannotation/$idannotation/user/$idUser/term.$format"(controller: "annotationTerm",
                    action: [GET: "listTermByAnnotation"])
            
            group("/annotation") {
                ".$format"(controller: "annotationDomain", action: [GET:"search", POST:"add"])
                "/$id.$format"(controller: "annotationDomain", action: [GET:"show", PUT:"update", DELETE:"delete"])
                "/$id/simplify.$format"(controller:"annotationDomain", action: [PUT:"simplify",GET:"simplify"])
                "/$id/crop.$format"(controller: "annotationDomain", action: [GET:"crop"])
                "/method/union.$format"(controller:"annotationDomain", action: [PUT:"union", GET:"union"])
                "/method/download(.$format)?"(controller:"annotationDomain", action: [GET: "downloadSearched"])
                
                //keep this for retrieval
                "/$id/cropMin.$format"(controller: "annotationDomain", action: [GET:"cropMin"])
            }
            "/simplify.$format"(controller:"annotationDomain", action: [PUT:"retrieveSimplify",POST:"retrieveSimplify"])
            "/annotationcorrection.$format"(controller:"annotationDomain", action: [POST:"addCorrection"])
            
            group("/userannotation") {
                ".$format"(controller:"userAnnotation", action: [GET: "list",POST:"add"])
                "/$id.$format"(controller:"userAnnotation", action: [GET:"show",PUT:"update", DELETE:"delete"])
                "/$id/crop.$format"(controller: "userAnnotation", action: [GET:"crop"])
                "/$id/mask.$format"(controller: "userAnnotation", action: [GET:"cropMask"])
                "/$id/alphamask.$format"(controller: "userAnnotation", action: [GET:"cropAlphaMask"])

                "/$annotation/comment.$format"(controller: "userAnnotation", action: [POST: "addComment", GET:"listComments"])
                "/$annotation/comment/$id.$format"(controller: "userAnnotation", action: [GET:"showComment"])
            }
            "/user/$id/userannotation/count.$format"(controller:"userAnnotation", action: [GET: "countByUser"])
            
            group("/algoannotation") {
                "/method/union.$format"(controller:"algoAnnotation",action:[PUT:"union", GET:"union"])
                ".$format"(controller:"algoAnnotation", action:[GET: "list",POST:"add"])
                "/$id.$format"(controller:"algoAnnotation", action:[GET:"show",PUT:"update", DELETE:"delete"])
                "/$id/crop.$format"(controller: "algoAnnotation", action:[GET:"crop"])
                "/$id/alphamask.$format"(controller: "algoAnnotation", action:[GET:"cropMask"])
                "/$id/mask.$format"(controller: "algoAnnotation", action:[GET:"cropAlphaMask"])

                "/$annotation/comment.$format"(controller: "algoAnnotation", action: [POST: "addComment", GET:"listComments"])
                "/$annotation/comment/$id.$format"(controller: "algoAnnotation", action: [GET:"showComment"])
            }

            group("/reviewedannotation") {
                ".$format"(controller:"reviewedAnnotation", action:[GET: "list",POST:"add"])
                "/$id.$format"(controller:"reviewedAnnotation", action:[GET:"show",PUT:"update", DELETE:"delete"])
                "/$id/crop.$format"(controller: "reviewedAnnotation", action:[GET:"crop"])
                "/$id/alphamask.$format"(controller: "reviewedAnnotation", action:[GET:"cropMask"])
                "/$id/mask.$format"(controller: "reviewedAnnotation", action:[GET:"cropAlphaMask"])
            }
            "/user/$id/reviewedannotation/count.$format"(controller:"reviewedAnnotation", action: [GET: "countByUser"])
            "/user/$iduser/reviewedannotation.$format"(controller: "reviewedAnnotation", action: [POST:"add"])
            "/annotation/$id/review.$format"(controller: "reviewedAnnotation", 
                    action: [GET: "addAnnotationReview",POST:"addAnnotationReview",
                             PUT:"addAnnotationReview",DELETE:"deleteAnnotationReview"])
            "/imageinstance/$id/review.$format"(controller: "reviewedAnnotation", 
                    action: [POST:"startImageInstanceReview",PUT:"startImageInstanceReview",
                             DELETE: "stopImageInstanceReview"])
            "/imageinstance/$image/annotation/review.$format"(controller: "reviewedAnnotation", 
                    action: [POST:"reviewLayer",PUT:"reviewLayer",DELETE: "unReviewLayer"])
            "/imageinstance/$image/reviewedannotation/stats.$format"(controller: "reviewedAnnotation",
                    action: [GET:"stats"])
            
            // Annotation Reporting
            "/project/$id/userannotation/download"(controller: "userAnnotation",action: [GET:"downloadDocumentByProject"])
            "/project/$id/algoannotation/download"(controller: "algoAnnotation", action: [GET:"downloadDocumentByProject"])
            "/project/$id/reviewedannotation/download"(controller: "reviewedAnnotation", action: [GET:"downloadDocumentByProject"])
            "/project/$id/annotation/download"(controller: "annotationDomain", action: [GET:"downloadDocumentByProject"])
            "/imageinstance/$idImage/annotation/included.$format"(controller:"annotationDomain", action: [GET: "listIncludedAnnotation"])
            "/imageinstance/$idImage/annotation/included/download"(controller: "annotationDomain", action: [GET:"downloadIncludedAnnotation"])


            group("/annotationfilter") {
                ".$format"(controller:"annotationFilter", action:[GET: "list",POST:"add"])
                "/$id.$format"(controller:"annotationFilter", action:[GET:"show",PUT:"update", DELETE:"delete"])
            }
            "/ontology/$idOntology/annotationfilter.$format"(controller: "annotationFilter", action: [GET:"listByOntology"])


            "/imageinstance/$id/annotationindex.$format"(controller:"annotationIndex", action: [GET:"listByImage"])
        }
    }
}