package be.cytomine.image.server

class UrlMappings {

    static mappings = {
        group("/api") {
            group("/storage") {
                ".$format"(controller: "storage", action: [GET:"list", POST:"add"])
                "/$id.$format"(controller: "storage", action: [GET:"show", PUT:"update", DELETE:"delete"])
                "/create/$user.$format"(controller : "storage", action: [POST:"create"])
            }
            
            group("/storage_abstract_image") {
                ".$format"(controller: "storageAbstractImage", action: [POST:"add"])
                "/$id.$format"(controller: "storageAbstractImage", action: [DELETE:"delete"])
            }
            
            "/imageserver.$format"(controller : "storage", action: [GET:"listByMime"])
        }
    }
}