package be.cytomine.image.multidim

class UrlMappings {

    static mappings = {
        group("/api") {
            
            group("/imagegroup") {
                ".$format"(controller: "imageGroup", action: [POST:"add"])
                "/$id.$format"(controller: "imageGroup", action: [GET:"show", PUT:"update", DELETE:"delete"])
                "/$id/characteristics.$format"(controller: "imageGroup", action: [GET:"characteristics"])
                "/$id/thumb.$format"(controller: "imageGroup", action: [GET:"thumb"])
            }
            "/project/$id/imagegroup.$format"(controller: "imageGroup", action: [GET:"listByProject"])
            
            group("/imagegroupHDF5") {
                ".$format"(controller: "imageGroupHDF5", action: [POST:"add"])
                "/$id.$format"(controller: "imageGroupHDF5", action: [GET:"show", PUT:"update", DELETE:"delete"])
                "/$id/$x/$y/pixel.$format"(controller: "imageGroupHDF5", action: [GET: "pixelHDF5"])
                "/$id/$x/$y/$w/$h/rectangle.$format"(controller: "imageGroupHDF5", action: [GET: "rectangleHDF5"])
            }
            "/imagegroup/$group/imagegroupHDF5.$format"(controller: "imageGroupHDF5",
                    action: [GET: "showFromImageGroup", DELETE:"deleteFromImageGroup"])
            
            group("/imagesequence") {
                ".$format"(controller: "imageSequence", action: [POST:"add"])
                "/$id.$format"(controller: "imageSequence", action: [GET:"show", PUT:"update", DELETE:"delete"])
            }
            "/imageinstance/$id/imagesequence.$format"(controller: "imageSequence", action: [GET:"getByImageInstance"])
            "/imageinstance/$id/imagesequence/possibilities.$format"(controller: "imageSequence", action: [GET:"getSequenceInfo"])
            "/imagegroup/$id/imagesequence.$format"(controller: "imageSequence", action: [GET:"listByImageGroup"])
            "/imagegroup/$id/$channel/$zstack/$slice/$time/imagesequence.$format"(controller: "imageSequence",
                    action: [GET:"getByImageGroupAndIndexes"])
        }
    }
}