package be.cytomine.image

class UrlMappings {

    static mappings = {
        group("/api") {
            group("/abstractimage") {
                ".$format"(controller: "abstractImage", action: [GET:"list", POST:"add"])
                "/$id.$format"(controller: "abstractImage", action: [GET:"show", PUT:"update", DELETE:"delete"])
                "/unused.$format"(controller:"abstractImage", action: [GET: "listUnused"])
                "/$id/user.$format"(controller:"abstractImage", action: [GET:"showUploaderOfImage"])
                
                "/$id/download"(controller: "abstractImage", action: [GET:"download"])
                "/$id/thumb.$format"(controller: "abstractImage", action: [GET:"thumb"])
                "/$id/preview.$format"(controller: "abstractImage", action: [GET:"preview"])
                "/$id/crop.$format"(controller: "abstractImage", action: [GET:"crop"])
                "/$id/camera.$format"(controller: "abstractImage", action: [GET:"camera"])
                
                "/$id/associated.$format"(controller: "abstractImage", action: [GET:"associated"])
                "/$id/associated/$label.$format"(controller: "abstractImage", action: [GET:"label"])
                "/$id/imageservers.$format"(controller: "abstractImage", action: [GET:"imageServers"])
                
                "/$id/properties/clear.$format"(controller:"uploadedFile", action: [POST:"clearProperties"])
                "/$id/properties/populate.$format"(controller:"uploadedFile", action: [POST:"populateProperties"])
                "/$id/properties/extract.$format"(controller:"uploadedFile", action: [POST:"extractProperties"])
            }
            "/project/$id/image.$format"(controller: "abstractImage", action: [GET:"listByProject"])
            
            
            group("/imageinstance") {
                ".$format"(controller: "imageInstance", action: [POST:"add"])
                "/$id.$format"(controller: "imageInstance", action: [GET:"show", PUT:"update", DELETE:"delete"])
                "/$id/next.$format"(controller: "imageInstance", action: [GET:"next"])
                "/$id/previous.$format"(controller: "imageInstance", action: [GET:"previous"])
                "/$id/window-$x-$y-$w-$h.$format"(controller: "imageInstance", action: [GET:"window"])
                "/$id/window_url-$x-$y-$w-$h.$format"(controller: "imageInstance", action: [GET:"windowUrl"])
                "/$id/download"(controller: "imageInstance", action: [GET:"download"])
                "/$id/associated.$format"(controller: "imageInstance", action: [GET:"associated"])
                "/$id/associated/$label.$format"(controller: "imageInstance", action: [GET:"label"])
                "/$id/camera.$format"(controller: "imageInstance", action: [GET:"camera"])
                "/$id/camera_url-$x-$y-$w-$h.$format"(controller: "imageInstance", action: [GET:"cameraUrl"])
                "/$id/cropgeometry.$format"(controller :"imageInstance", action: [GET:"cropGeometry"])
                "/$id/crop.$format"(controller :"imageInstance", action: [GET:"crop"])
                "/method/lastopened.$format"(controller :"imageInstance", action: [GET:"listLastOpenImage"])
                "/$id/sameimagedata.$format"(controller :"imageInstance", action: [GET:"retrieveSameImageOtherProject"])
                "/$id/copyimagedata.$format"(controller :"imageInstance", action: [POST:"copyAnnotationFromSameAbstractImage"])
                "/$id/copymetadata.$format"(controller :"imageInstance", action: [POST:"copyMetadata"])
                
                group("/$idImage/nested") {
                    ".$format"(controller: "nestedImageInstance", action: [POST:"add", GET : "listByImageInstance"])
                    "/$id.$format"(controller: "nestedImageInstance", action: [GET:"show", PUT:"update", DELETE:"delete"])
                }
            }
            "/project/$id/imageinstance.$format"(controller: "imageInstance", action: [GET:"listByProject"])
            "/user/$user/imageinstance/light.$format"(controller: "imageInstance", action: [GET:"listByUser"])
            
            group("/uploadedfile") {
                ".$format"(controller:"uploadedFile", action: [GET: "list",POST:"add"])
                "/$id.$format"(controller:"uploadedFile", action: [GET:"show",PUT:"update", DELETE:"delete"])
                "/image/$idimage.$format"(controller:"uploadedFile", action: [GET:"getByAbstractImage"])
                "/$uploadedFile/image.$format"(controller:"uploadedFile", action: [POST:"createImage"])
            }

            "/camera.$format"(controller: "abstractImage", action: [POST:"camera"])
        }
    }
}