package be.cytomine

import be.cytomine.exception.ForbiddenException
import org.springframework.security.access.AccessDeniedException
import org.springframework.security.acls.model.NotFoundException

class UrlMappings {

    static mappings = {
        "/$controller/$action?/$id?.$format?"{
            constraints {
                // apply constraints here
            }
        }
        "/$controller/$action?.$format?"{
            constraints {
                // apply constraints here
            }
        }

        delete "/$controller/$id(.$format)?"(action:"delete")
        get "/$controller(.$format)?"(action:"index")
        get "/$controller/$id(.$format)?"(action:"show")
        post "/$controller(.$format)?"(action:"save")
        put "/$controller/$id(.$format)?"(action:"update")
        patch "/$controller/$id(.$format)?"(action:"patch")

        "/"(controller: 'application', action:'index')
        "500"(view: '/error')
        "404"(view: '/notFound')

        "403"(controller: "errors", action: "error403")
        //"404.$format"(controller: "errors", action: "error404")
        "500"(controller: "errors", action: "error500")
        "500"(controller: "errors", action: "error403", exception: AccessDeniedException)
        "500"(controller: "errors", action: "error403", exception: NotFoundException)
        "500"(controller: "errors", action: "error403", exception: ForbiddenException)

        group("/custom-ui") {
            "/config.$format"(controller: "customUI", action: [GET: "retrieveUIConfig"])
            "/project/$project.$format"(controller: "customUI",
                    action: [GET:"showCustomUIForProject",POST:"addCustomUIForProject"])
        }
    }
}
