
import be.cytomine.ldap.CustomUserContextMapper
import be.cytomine.security.CASLdapUserDetailsService
import be.cytomine.security.SimpleUserDetailsService
import be.cytomine.security.interceptors.ApiAuthenticationFilter
import grails.core.GrailsApplication
import grails.orm.bootstrap.HibernateDatastoreSpringInitializer
import grails.plugin.springsecurity.SpringSecurityUtils
import org.grails.transaction.ChainedTransactionManager
import org.springframework.aop.scope.ScopedProxyFactoryBean
import org.springframework.cache.ehcache.EhCacheFactoryBean
import org.springframework.security.ldap.DefaultSpringSecurityContextSource
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator
import org.springframework.security.ldap.userdetails.LdapUserDetailsService

// Place your Spring DSL code here
beans = {
    xmlns util:"http://www.springframework.org/schema/util"

    logoutEventListener(LogoutEventListener)

    'apiAuthenticationFilter'(ApiAuthenticationFilter) {
        // properties
    }

//    'multipartResolver'(CytomineMultipartHttpServletRequest) {
//        // Max in memory 100kbytes
//        maxInMemorySize = 10240
//
//        //100Gb Max upload size
//        maxUploadSize = 102400000000
//    }

    springConfig.addAlias "springSecurityService", "springSecurityCoreSpringSecurityService"

    //CAS + LDAP STUFF
    def config = SpringSecurityUtils.securityConfig
    SpringSecurityUtils.loadSecondaryConfig 'DefaultLdapSecurityConfig'
    config = SpringSecurityUtils.securityConfig

    if (config.ldap.active) {
        initialDirContextFactory(DefaultSpringSecurityContextSource,
                config.ldap.context.server) {
            userDn = config.ldap.context.managerDn
            password = config.ldap.context.managerPassword
            anonymousReadOnly = config.ldap.context.anonymousReadOnly
        }

        ldapUserSearch(FilterBasedLdapUserSearch,
                config.ldap.search.base,
                config.ldap.search.filter,
                initialDirContextFactory) {
        }

        ldapAuthoritiesPopulator(DefaultLdapAuthoritiesPopulator,
                initialDirContextFactory,
                config.ldap.authorities.groupSearchBase) {
            groupRoleAttribute = config.ldap.authorities.groupRoleAttribute
            groupSearchFilter = config.ldap.authorities.groupSearchFilter
            searchSubtree = config.ldap.authorities.searchSubtree
            convertToUpperCase = config.ldap.mapper.convertToUpperCase
            ignorePartialResultException = config.ldap.authorities.ignorePartialResultException
        }

        ldapUserDetailsMapper(CustomUserContextMapper)

        ldapUserDetailsService(LdapUserDetailsService,
                ldapUserSearch,
                ldapAuthoritiesPopulator) {
            userDetailsMapper = ref('ldapUserDetailsMapper')
        }

        userDetailsService(CASLdapUserDetailsService) {
            ldapUserDetailsService = ref('ldapUserDetailsService')
            grailsApplication = ref('grailsApplication')
        }
    } else {
        userDetailsService(SimpleUserDetailsService)
    }

    ehcacheAclCache(EhCacheFactoryBean) {
        cacheManager = ref('aclCacheManager')
        cacheName = 'aclCache'
        overflowToDisk = false
    }

    currentRoleServiceProxy(ScopedProxyFactoryBean) {
        targetBeanName = 'currentRoleService'
        proxyTargetClass = true
    }
}
