grails.serverURL = "http://localhost-core:8080"
grails.uploadURL = "http://localhost-upload"
grails.imageServerURL = ["http://localhost-ims"]
grails.retrievalServerURL = ["http://localhost-retrieval"]


cytomine.middleware.rabbitmq.user = "router"
cytomine.middleware.rabbitmq.password = "router"

grails.admin.email = "info@cytomine.org"
grails.notification.email = ""
grails.notification.password = ""
grails.notification.smtp.host = "smtp.gmail.com"
grails.notification.smtp.port = "587"

grails.client = "NO"//"AURORA"

cytomine.customUI.project = [
        "project-annotations-tab":["ADMIN_PROJECT":true,"CONTRIBUTOR_PROJECT":true],
        "project-images-tab":["ADMIN_PROJECT":true,"CONTRIBUTOR_PROJECT":true],
        "project-imagegroups-tab":["ADMIN_PROJECT":false,"CONTRIBUTOR_PROJECT":false],
        "project-properties-tab":["ADMIN_PROJECT":true,"CONTRIBUTOR_PROJECT":true],
        "project-jobs-tab":["ADMIN_PROJECT":false,"CONTRIBUTOR_PROJECT":false],
        "project-configuration-tab":["ADMIN_PROJECT":true,"CONTRIBUTOR_PROJECT":false],
        "project-usersconfiguration-tab":["ADMIN_PROJECT":true,"CONTRIBUTOR_PROJECT":false],
        "project-explore-spectra-panel":["ADMIN_PROJECT":false,"CONTRIBUTOR_PROJECT":false]
]

cytomine.customUI.global = [
        dashboard: ["ALL"],
        search : ["ROLE_ADMIN"],
        project: ["ALL"],
        ontology: ["ROLE_ADMIN"],
        storage : ["ROLE_USER","ROLE_ADMIN"],
        activity : ["ALL"],
        feedback : ["ROLE_USER","ROLE_ADMIN"],
        explore : ["ROLE_USER","ROLE_ADMIN"],
        admin : ["ROLE_ADMIN"],
        help : ["ALL"]
]


grails.plugin.springsecurity.interceptUrlMap = [
//        '/admin/**':    ['ROLE_ADMIN','ROLE_SUPER_ADMIN'],
//        '/admincyto/**':    ['ROLE_ADMIN','ROLE_SUPER_ADMIN'],
//        '/monitoring/**':    ['ROLE_ADMIN','ROLE_SUPER_ADMIN'],
//        '/securityInfo/**': ['ROLE_ADMIN','ROLE_SUPER_ADMIN'],
        [pattern: '/j_spring_security_switch_user', access: ['ROLE_ADMIN','ROLE_SUPER_ADMIN']],
        [pattern: '/api/**', access:      ['IS_AUTHENTICATED_REMEMBERED']],
        [pattern: '/lib/**', access:      ['IS_AUTHENTICATED_ANONYMOUSLY']],
        [pattern: '/css/**', access:      ['IS_AUTHENTICATED_ANONYMOUSLY']],
        [pattern: '/images/**', access:   ['IS_AUTHENTICATED_ANONYMOUSLY']],
//        [pattern: '/*', access:           ['IS_AUTHENTICATED_REMEMBERED']], //if cas authentication, active this      //beta comment
        [pattern: '/login/**', access:    ['IS_AUTHENTICATED_ANONYMOUSLY']],
        [pattern: '/logout/**', access:   ['IS_AUTHENTICATED_ANONYMOUSLY']],
        [pattern: '/status/**', access:   ['IS_AUTHENTICATED_ANONYMOUSLY']]
]

grails.readOnlyProjectsByDefault = true
grails.adminPassword="admin"

// RabbitMQ server
grails.messageBrokerServerURL = "rabbitmq:5672"
grails.LTIConsumer = []

cytomine.jobdata.filesystem = false
cytomine.jobdata.filesystemPath = "algo/data/"

cytomine.maxRequestSize = 10485760
storage_path="/data" //default path for image locations
fast_data_path="/data" //default path for HDF5 files location (for ex: a SSD)

grails.gorm.default.mapping = {
    autowire true
}

grails.adminPrivateKey="3"
grails.adminPublicKey="4"
grails.superAdminPrivateKey="5"
grails.superAdminPublicKey="6"

grails.databinding.convertEmptyStringsToNull = false