d3_transitionPrototype.style = function(name, value, priority) {
  var n = arguments.length;
  if (n < 3) {

    // For style(object) or style(object, string), the object specifies the
    // names and values of the attributes to set or remove. The values may be
    // functions that are evaluated for each element. The optional string
    // specifies the priority.
    if (typeof name !== "string") {
      if (n < 2) value = "";
      for (priority in name) this.style(priority, name[priority], value);
      return this;
    }

    // For style(string, string) or style(string, function), use the default
    // priority. The priority is ignored for style(string, null).
    priority = "";
  }

  var interpolate = d3_interpolateByName(name);

  // For style(name, null) or style(name, null, priority), remove the style
  // property with the specified name. The priority is ignored.
  function styleNull() {
    // R2D3 OVERRIDE
    if (this.raphaelNode) {
      this.removeStyleProperty(name);
    } else {
      if (this.style.removeProperty) {
        this.style.removeProperty(name);
      } else {
        this.style.removeAttribute(name);
      }
    }
  }

  // Otherwise, a name, value and priority are specified, and handled as below.
  return d3_transition_tween(this, "style." + name, value, function(b) {

    // For style(name, string) or style(name, string, priority), set the style
    // property with the specified name, using the specified priority.
    function styleString() {

      // R2D3 OVERRIDE
      if (this.raphaelNode) {
        var a =  this.getCurrentStyle()[name], i;
        return a !== b && (i = interpolate(a, b), function(t) { this.setStyleProperty(name, i(t), priority); });
      }

      var a = d3_window.getComputedStylePropertyValue(this, name), i;
      return a !== b && (i = interpolate(a, b), function(t) {
        if (this.style.setProperty) {
          this.style.setProperty(name, i(t), priority);
        } else {
          this.style[name] = i(t);
        }
      });
    }

    return b == null ? styleNull
        : (b += "", styleString);
  });
};

d3_transitionPrototype.styleTween = function(name, tween, priority) {
  if (arguments.length < 3) priority = "";

  if (this.raphaelNode) {
    // R2D3 OVERRIDE
    return this.tween("style." + name, function(d, i) {
      var f = tween.call(this, d, i, this.getCurrentStyle()[name]);
      return f && function(t) { this.setStyleProperty(name, f(t), priority); };
    });
  }

  return this.tween("style." + name, function(d, i) {
    var f = tween.call(this, d, i, d3_window.getComputedStylePropertyValue(this, name));
    return f && function(t) {
      if (this.style.setProperty) {
        this.style.setProperty(name, f(t), priority);
      } else {
        this.style[name] = f(t);
      }
    };
  });
};
