var specsJQuery = function(context){
	
	var document = context.document;
	var SELECT = context.SELECT;
	var test = describe;
	
	var jQuery = function(expression, root){
		var ret = [];
		root = root || document;
		if (typeof root == 'string') root = SELECT(document, root);
		if ('length' in root){
			for (var i = 0, el; (el = root[i++]);){
				ret = SELECT(el, expression, ret);
			}
		} else {
			ret = SELECT(root, expression);
		}
		return ret;
	};
	var ok = function(a, message){
		it(message, function(){
			expect(!!a).toEqual(true);
		});
	};
	var equals = function(a, b, message){
		it(message, function(){
			expect(a).toEqual(b);
		});
	};
	var same = function(a, b, message){
		it(message, function(){
			expect(a.length).toEqual(b.length);
			for (var i = 0; i < a.length; i++){
				expect(a[i]).toEqual(b[i]);
			}
		});
	};
	var t = function(message, expression, ids){
		it(message, function(){
			var values = jQuery(expression);
			expect(values.length).toEqual(ids.length);
			for (var i = 0; i < values.length; i++){
				expect(values[i].getAttribute('id')).toEqual(ids[i]);
			}
		});
	};
	var q = function(){
		var r = [];
		for (var i = 0; i < arguments.length; i++){
			r.push(document.getElementById(arguments[i]));
		}
		return r;
	};
	context.Array.prototype.size = Array.prototype.size = function(){
		return this.length;
	};
	context.Array.prototype.get = Array.prototype.get = function(){
		return this;
	};
	context.Array.prototype.find = Array.prototype.find = function(expression){
		return jQuery(expression, this);
	};
	
	test('element', function(specs){
		ok( jQuery("*").size() >= 30, "Select all" );
		var all = jQuery("*"), good = true;
		for ( var i = 0; i < all.length; i++ ){
			if ( all[i].nodeType == 8 ) good = false;
		}
			
		ok( good, "Select all elements, no comment nodes" );
		t( "Element Selector", "p", ["firstp","ap","sndp","en","sap","first"] );
		t( "Element Selector 1", "body", ["body"] );
		t( "Element Selector 2", "html", ["html"] );
		t( "Parent Element", "div p", ["firstp","ap","sndp","en","sap","first"] );
		equals( jQuery("param", "#object1").length, 2, "Object/param as context" );
		// NWSAPI does not support NodeList/HTMLCollection/Array as context argument but there is a very useful callback parameter
//		same( jQuery("p", document.getElementsByTagName("div")).get(), q("firstp","ap","sndp","en","sap","first"), "Finding elements with a context." );
//		same( jQuery("p", "div").get(), q("firstp","ap","sndp","en","sap","first"), "Finding elements with a context." );
//		same( jQuery("p", jQuery("div")).get(), q("firstp","ap","sndp","en","sap","first"), "Finding elements with a context. 1" );
//		same( jQuery("div").find("p").get(), q("firstp","ap","sndp","en","sap","first"), "Finding elements with a context. 2" );

		ok( jQuery("#length").length, '&lt;input name="length"&gt; cannot be found under IE, see #945' );
		ok( jQuery("#lengthtest input").length, '&lt;input name="length"&gt; cannot be found under IE, see #945' );

		// Check for unique-ness and sort order
		same( jQuery("*").get(), jQuery("*, *").get(), "Check for duplicates: *, *" );
		same( jQuery("p").get(), jQuery("p, div p").get(), "Check for duplicates: p, div p" );

		t( "Checking sort order", "h2, h1", ["qunit-header", "qunit-banner", "qunit-userAgent"] );
		//t( "Checking sort order 1", "h2:first, h1:first", ["qunit-header", "qunit-banner"] );
		t( "Checking sort order 2", "p, p a", ["firstp", "simon1", "ap", "google", "groups", "anchor1", "mark", "sndp", "en", "yahoo", "sap", "anchor2", "simon", "first"] );
	});

	test("id", function(specs) {
		t( "ID Selector", "#body", ["body"] );
		t( "ID Selector w/ Element", "body#body", ["body"] );
		t( "ID Selector w/ Element", "ul#first", [] );
		t( "ID selector with existing ID descendant", "#firstp #simon1", ["simon1"] );
		t( "ID selector with non-existant descendant", "#firstp #foobar", [] );
		t( "ID selector using UTF8", "#台北Táiběi", ["台北Táiběi"] );
		t( "Multiple ID selectors using UTF8", "#台北Táiběi, #台北", ["台北Táiběi","台北"] );
		t( "Descendant ID selector using UTF8", "div #台北", ["台北"] );
		t( "Child ID selector using UTF8", "form > #台北", ["台北"] );
	
		t( "Escaped ID", "#foo\\:bar", ["foo:bar"] );
		t( "Escaped ID 1", "#test\\.foo\\[5\\]bar", ["test.foo[5]bar"] );
		t( "Descendant escaped ID", "div #foo\\:bar", ["foo:bar"] );
		t( "Descendant escaped ID 1", "div #test\\.foo\\[5\\]bar", ["test.foo[5]bar"] );
		t( "Child escaped ID", "form > #foo\\:bar", ["foo:bar"] );
		t( "Child escaped ID 1", "form > #test\\.foo\\[5\\]bar", ["test.foo[5]bar"] );
	
		t( "ID Selector, child ID present", "#form > #radio1", ["radio1"] ); // bug #267
		t( "ID Selector, not an ancestor ID", "#form #first", [] );
		t( "ID Selector, not a child ID", "#form > #option1a", [] );
	
		t( "All Children of ID", "#foo > *", ["sndp", "en", "sap"] );
		t( "All Children of ID with no children", "#firstUL > *", [] );
	
		//jQuery('<a name="tName1">tName1 A</a><a name="tName2">tName2 A</a><div id="tName1">tName1 Div</div>').appendTo('#main');
		//equals( jQuery("#tName1")[0].id, 'tName1', "ID selector with same value for a name attribute" );
		equals( jQuery("#tName2").length, 0, "ID selector non-existing but name attribute on an A tag" );
		t( "ID Selector on Form with an input that has a name of 'id'", "#lengthtest", ["lengthtest"] );
	
		t( "ID selector with non-existant ancestor", "#asdfasdf #foobar", [] ); // bug #986

		same( jQuery("body").find("div#form").get(), [], "ID selector within the context of another element" );

		t( "Underscore ID", "#types_all", ["types_all"] );
		t( "Dash ID", "#fx-queue", ["fx-queue"] );

		t( "ID with weird characters in it", "#name\\+value", ["name+value"] );
	});

	test("class", function(specs) {
		t( "Class Selector", ".blog", ["mark","simon"] );
		t( "Class Selector 1", ".GROUPS", ["groups"] );
		t( "Class Selector 2", ".blog.link", ["simon"] );
		t( "Class Selector w/ Element", "a.blog", ["mark","simon"] );
		t( "Parent Class Selector", "p .blog", ["mark","simon"] );

		same( jQuery(".blog", document.getElementsByTagName("p")).get(), q("mark", "simon"), "Finding elements with a context." );
		same( jQuery(".blog", "p").get(), q("mark", "simon"), "Finding elements with a context. 1" );
		same( jQuery(".blog", jQuery("p")).get(), q("mark", "simon"), "Finding elements with a context. 2" );
		same( jQuery("p").find(".blog").get(), q("mark", "simon"), "Finding elements with a context. 3" );
	
		t( "Class selector using UTF8", ".台北Táiběi", ["utf8class1"] );
		t( "Class selector using UTF8 1", ".台北", ["utf8class1","utf8class2"] );
		t( "Class selector using UTF8 2", ".台北Táiběi.台北", ["utf8class1"] );
		t( "Class selector using UTF8 3", ".台北Táiběi, .台北", ["utf8class1","utf8class2"] );
		t( "Descendant class selector using UTF8", "div .台北Táiběi", ["utf8class1"] );
		t( "Child class selector using UTF8", "form > .台北Táiběi", ["utf8class1"] );

		t( "Escaped Class", ".foo\\:bar", ["foo:bar"] );
		t( "Escaped Class 1", ".test\\.foo\\[5\\]bar", ["test.foo[5]bar"] );
		t( "Descendant scaped Class", "div .foo\\:bar", ["foo:bar"] );
		t( "Descendant scaped Class 1", "div .test\\.foo\\[5\\]bar", ["test.foo[5]bar"] );
		t( "Child escaped Class", "form > .foo\\:bar", ["foo:bar"] );
		t( "Child escaped Class 1", "form > .test\\.foo\\[5\\]bar", ["test.foo[5]bar"] );

		var div = document.createElement("div");
	  	div.innerHTML = "<div class='test e'></div><div class='test'></div>";
		//same( jQuery(".e", div).get(), [ div.firstChild ], "Finding a second class." );

		div.lastChild.className = "e";

		//same( jQuery(".e", div).get(), [ div.firstChild, div.lastChild ], "Finding a modified class." );
	});

	test("name", function(specs) {
		t( "Name selector", "input[name=action]", ["text1"] );
		t( "Name selector with single quotes", "input[name='action']", ["text1"] );
		t( "Name selector with double quotes", 'input[name="action"]', ["text1"] );

		t( "Name selector non-input", "[name=test]", ["length", "fx-queue"] );
		t( "Name selector non-input 1", "[name=div]", ["fadein"] );
		t( "Name selector non-input 2", "*[name=iframe]", ["iframe"] );

		t( "Name selector for grouped input", "input[name='types[]']", ["types_all", "types_anime", "types_movie"] );

		same( jQuery("#form").find("input[name=action]").get(), q("text1"), "Name selector within the context of another element" );
		same( jQuery("#form").find("input[name='foo[bar]']").get(), q("hidden2"), "Name selector for grouped form element within the context of another element" );

		t( "Form with attribute action and an input with the same id inside it", "#form[action='formaction']", ["form"] );

		// fabiomcosta: maybe these specs where forgotten here by mistake, these ids/names are not in the jquery mock.
		//var a = jQuery('<a id="tName1ID" name="tName1">tName1 A</a><a id="tName2ID" name="tName2">tName2 A</a><div id="tName1">tName1 Div</div>').appendTo('#main');
		//t( "Find elements that have similar IDs", "[name=tName1]", ["tName1ID"] );
		//t( "Find elements that have similar IDs 1", "[name=tName2]", ["tName2ID"] );
	});


	test("multiple", function() {
		t( "Comma Support", "h2, p", ["qunit-banner","qunit-userAgent","firstp","ap","sndp","en","sap","first"]);
		t( "Comma Support 1", "h2 , p", ["qunit-banner","qunit-userAgent","firstp","ap","sndp","en","sap","first"]);
		t( "Comma Support 2", "h2 , p", ["qunit-banner","qunit-userAgent","firstp","ap","sndp","en","sap","first"]);
		t( "Comma Support 3", "h2,p", ["qunit-banner","qunit-userAgent","firstp","ap","sndp","en","sap","first"]);
	});

	test("child and adjacent", function() {
		t( "Child", "p > a", ["simon1","google","groups","mark","yahoo","simon"] );
		t( "Child 1", "p> a", ["simon1","google","groups","mark","yahoo","simon"] );
		t( "Child 2", "p >a", ["simon1","google","groups","mark","yahoo","simon"] );
		t( "Child 3", "p>a", ["simon1","google","groups","mark","yahoo","simon"] );
		t( "Child w/ Class", "p > a.blog", ["mark","simon"] );
		t( "All Children", "code > *", ["anchor1","anchor2"] );
		t( "All Grandchildren", "p > * > *", ["anchor1","anchor2"] );
		t( "Adjacent", "a + a", ["groups"] );
		t( "Adjacent 1", "a +a", ["groups"] );
		t( "Adjacent 2", "a+ a", ["groups"] );
		t( "Adjacent 3", "a+a", ["groups"] );
		t( "Adjacent 4", "p + p", ["ap","en","sap"] );
		t( "Adjacent 5", "p#firstp + p", ["ap"] );
		t( "Adjacent 6", "p[lang=en] + p", ["sap"] );
		t( "Adjacent 7", "a.GROUPS + code + a", ["mark"] );
		t( "Comma, Child, and Adjacent", "a + a, code > a", ["groups","anchor1","anchor2"] );

		t( "Verify deep class selector", "div.blah > p > a", [] );

		t( "No element deep selector", "div.foo > span > a", [] );
		t( "No element not selector", ".container div:not(.excluded) div", [] );

		//same( jQuery("> :first", document.getElementById("nothiddendiv")).get(), q("nothiddendivchild"), "Verify child context positional selctor" );
		//same( jQuery("> :eq(0)", document.getElementById("nothiddendiv")).get(), q("nothiddendivchild"), "Verify child context positional selctor" );
		//same( jQuery("> *:first", document.getElementById("nothiddendiv")).get(), q("nothiddendivchild"), "Verify child context positional selctor" );

		t( "Non-existant ancestors", ".fototab > .thumbnails > a", [] );
	
		t( "First Child", "p:first-child", ["firstp","sndp"] );
		t( "Nth Child", "p:nth-child(1)", ["firstp","sndp"] );
		t( "Not Nth Child", "p:not(:nth-child(1))", ["ap","en","sap","first"] );

		// Verify that the child position isn't being cached improperly
		//jQuery("p:first-child").after("<div></div>");
		//jQuery("p:first-child").before("<div></div>").next().remove();

		//t( "First Child", "p:first-child", [] );

		t( "Last Child", "p:last-child", ["sap"] );
		t( "Last Child 1", "a:last-child", ["simon1","anchor1","mark","yahoo","anchor2","simon","liveLink1","liveLink2"] );
	
		t( "Nth-child", "#main form#form > *:nth-child(2)", ["text1"] );
		t( "Nth-child 2", "#main form#form > :nth-child(2)", ["text1"] );

		// fabiomcosta: pseudo-class :first is not support by slick
		//t( "Nth-child 3", "#form select:first option:nth-child(3)", ["option1c"] );
		//t( "Nth-child 4", "#form select:first option:nth-child(0n+3)", ["option1c"] );
		//t( "Nth-child 5", "#form select:first option:nth-child(1n+0)", ["option1a", "option1b", "option1c", "option1d"] );
		//t( "Nth-child 6", "#form select:first option:nth-child(1n)", ["option1a", "option1b", "option1c", "option1d"] );
		//t( "Nth-child 7", "#form select:first option:nth-child(n)", ["option1a", "option1b", "option1c", "option1d"] );
		//t( "Nth-child 8", "#form select:first option:nth-child(even)", ["option1b", "option1d"] );
		//t( "Nth-child 9", "#form select:first option:nth-child(odd)", ["option1a", "option1c"] );
		//t( "Nth-child 10", "#form select:first option:nth-child(2n)", ["option1b", "option1d"] );
		//t( "Nth-child 11", "#form select:first option:nth-child(2n+1)", ["option1a", "option1c"] );
		//t( "Nth-child 12", "#form select:first option:nth-child(3n)", ["option1c"] );
		//t( "Nth-child 13", "#form select:first option:nth-child(3n+1)", ["option1a", "option1d"] );
		//t( "Nth-child 14", "#form select:first option:nth-child(3n+2)", ["option1b"] );
		//t( "Nth-child 15", "#form select:first option:nth-child(3n+3)", ["option1c"] );
		//t( "Nth-child 16", "#form select:first option:nth-child(3n-1)", ["option1b"] );
		//t( "Nth-child 17", "#form select:first option:nth-child(3n-2)", ["option1a", "option1d"] );
		//t( "Nth-child 18", "#form select:first option:nth-child(3n-3)", ["option1c"] );
		//t( "Nth-child 19", "#form select:first option:nth-child(3n+0)", ["option1c"] );
		//t( "Nth-child 20", "#form select:first option:nth-child(-n+3)", ["option1a", "option1b", "option1c"] );
	});

	test("attributes", function(specs) {
		t( "Attribute Exists", "a[title]", ["google"] );
		t( "Attribute Exists 1", "*[title]", ["google"] );
		t( "Attribute Exists 2", "[title]", ["google"] );
		t( "Attribute Exists 3", "a[ title ]", ["google"] );
	
		t( "Attribute Equals", "a[rel='bookmark']", ["simon1"] );
		t( "Attribute Equals 1", 'a[rel="bookmark"]', ["simon1"] );
		t( "Attribute Equals 2", "a[rel=bookmark]", ["simon1"] );
		t( "Attribute Equals 3", "a[href='http://www.google.com/']", ["google"] );
		t( "Attribute Equals 4", "a[ rel = 'bookmark' ]", ["simon1"] );

		document.getElementById("anchor2").href = "#2";
		t( "href Attribute", "p a[href^='#']", ["anchor2"] );
		t( "href Attribute 1", "p a[href*='#']", ["simon1", "anchor2"] );

		t( "for Attribute", "form label[for]", ["label-for"] );
		t( "for Attribute in form", "#form [for=action]", ["label-for"] );

		//jQuery("form input")[0].test = 0;
		//jQuery("form input")[1].test = 1;
	  	// Disabled tests - expandos don't work in all browsers
		//t( "Expando attribute", "form input[test]", ["text1", "text2"] );
		//t( "Expando attribute value", "form input[test=0]", ["text1"] );
		//t( "Expando attribute value", "form input[test=1]", ["text2"] );
	
		t( "Attribute containing []", "input[name^='foo[']", ["hidden2"] );
		t( "Attribute containing [] 1", "input[name^='foo[bar]']", ["hidden2"] );
		t( "Attribute containing [] 2", "input[name*='[bar]']", ["hidden2"] );
		t( "Attribute containing [] 3", "input[name$='bar]']", ["hidden2"] );
		t( "Attribute containing [] 4", "input[name$='[bar]']", ["hidden2"] );
		t( "Attribute containing [] 5", "input[name$='foo[bar]']", ["hidden2"] );
		t( "Attribute containing [] 6", "input[name*='foo[bar]']", ["hidden2"] );
	
		t( "Multiple Attribute Equals", "#form input[type='radio'], #form input[type='hidden']", ["radio1", "radio2", "hidden1"] );
		t( "Multiple Attribute Equals 1", "#form input[type='radio'], #form input[type=\"hidden\"]", ["radio1", "radio2", "hidden1"] );
		t( "Multiple Attribute Equals 2", "#form input[type='radio'], #form input[type=hidden]", ["radio1", "radio2", "hidden1"] );
	
		t( "Attribute selector using UTF8", "span[lang=中文]", ["台北"] );
	
		t( "Attribute Begins With", "a[href ^= 'http://www']", ["google","yahoo"] );
		t( "Attribute Ends With", "a[href $= 'org/']", ["mark"] );
		t( "Attribute Contains", "a[href *= 'google']", ["google","groups"] );
		t( "Attribute Is Not Equal", "#ap a:not([hreflang='en'])", ["google","groups","anchor1"] );

		t("Empty values", "#select1 option[value='']", ["option1a"]);
		t("Empty values 1", "#select1 option[value!='']", ["option1b","option1c","option1d"]);
	
		t("Select options via :selected", "#select1 option:selected", ["option1a"] );
		t("Select options via :selected 1", "#select2 option:selected", ["option2d"] );
		t("Select options via :selected 2", "#select3 option:selected", ["option3b", "option3c"] );
	
		t( "Grouped Form Elements", "input[name='foo[bar]']", ["hidden2"] );
	
		t( ":not() Existing attribute", "#form select:not([multiple])", ["select1", "select2"]);
		t( ":not() Equals attribute", "#form select:not([name=select1])", ["select2", "select3"]);
		t( ":not() Equals quoted attribute", "#form select:not([name='select1'])", ["select2", "select3"]);
	});

	test("pseudo (:) selectors", function(specs) {
		t( "First Child", "p:first-child", ["firstp","sndp"] );
		t( "Last Child", "p:last-child", ["sap"] );
		t( "Only Child", "a:only-child", ["simon1","anchor1","yahoo","anchor2","liveLink1","liveLink2"] );
		t( "Empty", "ul:empty", ["firstUL"] );
		// Temporarily disabled some tests - Opera 10 doesn't appear to support
		//  disabled/enabled/checked properly.
		t( "Enabled UI Element", "#form input:not([type=hidden]):enabled", ["text1","radio1","radio2","check1","check2","hidden2","name","search"] );
		t( "Disabled UI Element", "#form input:disabled", ["text2"] );
		t( "Checked UI Element", "#form input:checked", ["radio2","check1"] );

		// Remove custom selectors (jddalton)
		//t( "Selected Option Element", "#form option:selected", ["option1a","option2d","option3b","option3c"] );
		//t( "Text Contains", "a:contains('Google')", ["google","groups"] );
		//t( "Text Contains 1", "a:contains('Google Groups')", ["groups"] );

		//t( "Text Contains 2", "a:contains('Google Groups (Link)')", ["groups"] );
		//t( "Text Contains 3", "a:contains('(Link)')", ["groups"] );

		t( "Element Preceded By", "p ~ div", ["foo", "moretests","tabindex-tests", "liveHandlerOrder"] );
		t( "Not", "a.blog:not(.link)", ["mark"] );
		//t( "Not - multiple", "#form option:not(:contains('Nothing'),#option1b,:selected)", ["option1c", "option1d", "option2b", "option2c", "option3d", "option3e"] );
		//t( "Not - complex", "#form option:not([id^='opt']:nth-child(-n+3))", [ "option1a", "option1d", "option2d", "option3d", "option3e"] );
		//t( "Not - recursive", "#form option:not(:not(:selected))[id^='option3']", [ "option3b", "option3c"] );

		t( ":not() failing interior", "p:not(.foo)", ["firstp","ap","sndp","en","sap","first"] );

        // invalid compound selectors (dperini)
//		t( ":not() failing interior 1", "p:not(div.foo)", ["firstp","ap","sndp","en","sap","first"] );
//		t( ":not() failing interior 2", "p:not(p.foo)", ["firstp","ap","sndp","en","sap","first"] );
		// equivalent substitutes
		t( ":not() failing interior 1", "p:not(div):not(.foo)", ["firstp","ap","sndp","en","sap","first"] );
		t( ":not() failing interior 2", "p:not(.foo)", ["firstp","ap","sndp","en","sap","first"] );

		t( ":not() failing interior 3", "p:not(#blargh)", ["firstp","ap","sndp","en","sap","first"] );

        // invalid compound selectors (dperini)
//		t( ":not() failing interior 4", "p:not(div):not(#blargh)", ["firstp","ap","sndp","en","sap","first"] );
//		t( ":not() failing interior 5", "p:not(p):not(#blargh)", ["firstp","ap","sndp","en","sap","first"] );
		t( ":not() failing interior 4", "p:not(div):not(#blargh)", ["firstp","ap","sndp","en","sap","first"] );
		t( ":not() failing interior 5", "p:not(#blargh)", ["firstp","ap","sndp","en","sap","first"] );

		t( ":not Multiple", "p:not(a)", ["firstp","ap","sndp","en","sap","first"] );
		//t( ":not Multiple 1", "p:not(a, b)", ["firstp","ap","sndp","en","sap","first"] );
		//t( ":not Multiple 2", "p:not(a, b, div)", ["firstp","ap","sndp","en","sap","first"] );
		t( ":not Multiple 3", "p:not(p)", [] );
		//t( ":not Multiple 4", "p:not(a,p)", [] );
		//t( ":not Multiple 5", "p:not(p,a)", [] );
		//t( ":not Multiple 6", "p:not(a,p,b)", [] );
		//t( ":not Multiple", ":input:not(:image,:input,:submit)", [] );
	
		//t( "nth Element", "p:nth(1)", ["ap"] );
		//t( "First Element", "p:first", ["firstp"] );
		//t( "Last Element", "p:last", ["first"] );
		//t( "Odd Elements", "p:odd", ["firstp","sndp","sap", "first"] );
		//t( "Even Elements", "p:even", ["ap","en"] );
		//t( "Position Equals", "p:eq(1)", ["ap"] );
		//t( "Position Greater Than", "p:gt(0)", ["ap","sndp","en","sap","first"] );
		//t( "Position Less Than", "p:lt(3)", ["firstp","ap","sndp"] );
		//t( "Is A Parent", "p:parent", ["firstp","ap","sndp","en","sap","first"] );
		//t( "Is Visible", "#form input:visible", [] );
		//t( "Is Visible", "div:visible:not(#qunit-testrunner-toolbar):lt(2)", ["nothiddendiv", "nothiddendivchild"] );
		//t( "Is Hidden", "#form input:hidden", ["text1","text2","radio1","radio2","check1","check2","hidden1","hidden2","name","search"] );
		//t( "Is Hidden", "#main:hidden", ["main"] );
		//t( "Is Hidden", "#dl:hidden", ["dl"] );


		//var $div = jQuery('#nothiddendivchild');
		//$div.css({ fontSize: 0, lineHeight: 0 });// IE also needs to set font-size and line-height to 0
		//$div.width(0).height(0);
		//t( "Is Hidden", '#nothiddendivchild:hidden', ['nothiddendivchild'] );
		//t( "Is Not Hidden", '#nothiddendivchild:visible', [] );
		//$div.width(1).height(0);
		//t( "Is Visible", '#nothiddendivchild:visible', ['nothiddendivchild'] );
		//t( "Is Not Visible", '#nothiddendivchild:hidden', [] );
		//$div.width(0).height(1);
		//t( "Is Visible", '#nothiddendivchild:visible', ['nothiddendivchild'] );
		//t( "Is Not Visible", '#nothiddendivchild:hidden', [] );
		//$div.width(1).height(1);
		//t( "Is Visible", '#nothiddendivchild:visible', ['nothiddendivchild'] );
		//t( "Is Not Visible", '#nothiddendivchild:hidden', [] );
		//$div.width('').height('').css({ fontSize: '', lineHeight: '' });
		
		
		//t( "Check position filtering", "div#nothiddendiv:eq(0)", ["nothiddendiv"] );
		//t( "Check position filtering", "div#nothiddendiv:last", ["nothiddendiv"] );
		//t( "Check position filtering", "div#nothiddendiv:not(:gt(0))", ["nothiddendiv"] );
		//t( "Check position filtering", "#foo > :not(:first)", ["en", "sap"] );
		//t( "Check position filtering", "select > :not(:gt(2))", ["option1a", "option1b", "option1c"] );
		//t( "Check position filtering", "select:lt(2) :not(:first)", ["option1b", "option1c", "option1d", "option2a", "option2b", "option2c", "option2d"] );
		//t( "Check position filtering", "div.nothiddendiv:eq(0)", ["nothiddendiv"] );
		//t( "Check position filtering", "div.nothiddendiv:last", ["nothiddendiv"] );
		//t( "Check position filtering", "div.nothiddendiv:not(:lt(0))", ["nothiddendiv"] );

		//t( "Check element position", "div div:eq(0)", ["nothiddendivchild"] );
		//t( "Check element position", "div div:eq(5)", ["t2037"] );
		//t( "Check element position", "div div:eq(27)", ["hide"] );
		//t( "Check element position", "div div:first", ["nothiddendivchild"] );
		//t( "Check element position", "div > div:first", ["nothiddendivchild"] );
		//t( "Check element position", "#dl div:first div:first", ["foo"] );
		//t( "Check element position", "#dl div:first > div:first", ["foo"] );
		//t( "Check element position", "div#nothiddendiv:first > div:first", ["nothiddendivchild"] );
	
		//t( "Form element :input", "#form :input", ["text1", "text2", "radio1", "radio2", "check1", "check2", "hidden1", "hidden2", "name", "search", "button", "area1", "select1", "select2", "select3"] );
		//t( "Form element :radio", "#form :radio", ["radio1", "radio2"] );
		//t( "Form element :checkbox", "#form :checkbox", ["check1", "check2"] );
		//t( "Form element :text", "#form :text:not(#search)", ["text1", "text2", "hidden2", "name"] );
		//t( "Form element :radio:checked", "#form :radio:checked", ["radio2"] );
		//t( "Form element :checkbox:checked", "#form :checkbox:checked", ["check1"] );
		//t( "Form element :radio:checked, :checkbox:checked", "#form :radio:checked, #form :checkbox:checked", ["radio2", "check1"] );

		//t( "Headers", ":header", ["qunit-header", "qunit-banner", "qunit-userAgent"] );
		//t( "Has Children - :has()", "p:has(a)", ["firstp","ap","en","sap"] );
	});

/*	if ( location.protocol != "file:" ) {
		test("XML Document Selectors", function() {
			expect(7);
			stop();
			jQuery.get("data/with_fries.xml", function(xml) {
				equals( jQuery("foo_bar", xml).length, 1, "Element Selector with underscore" );
				equals( jQuery(".component", xml).length, 1, "Class selector" );
				equals( jQuery("[class*=component]", xml).length, 1, "Attribute selector for class" );
				equals( jQuery("property[name=prop2]", xml).length, 1, "Attribute selector with name" );
				equals( jQuery("[name=prop2]", xml).length, 1, "Attribute selector with name" );
				equals( jQuery("#seite1", xml).length, 1, "Attribute selector with ID" );
				equals( jQuery("component#seite1", xml).length, 1, "Attribute selector with ID" );
				start();
			});
		});
	}

	test("broken", function() {
		function broken(name, selector) {
			try {
				jQuery(selector);
			}catch(e){
				ok( typeof e === "string" && e.indexOf("Syntax error") >= 0, name + ": " + selector );
			}
		}
	
		broken( "Broken Selector", "[", [] );
		broken( "Broken Selector", "(", [] );
		broken( "Broken Selector", "{", [] );
		broken( "Broken Selector", "<", [] );
		broken( "Broken Selector", "()", [] );
		broken( "Broken Selector", "<>", [] );
		broken( "Broken Selector", "{}", [] );
	});
*/

};

