/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.coverage;

import com.google.inject.Inject;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.coverage.Code;
import com.google.jstestdriver.coverage.Coverage;
import com.google.jstestdriver.coverage.CoverageAccumulator;
import com.google.jstestdriver.coverage.InstrumentedCode;
import com.google.jstestdriver.coverage.Instrumentor;
import com.google.jstestdriver.hooks.FileLoadPostProcessor;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageInstrumentingProcessor
implements FileLoadPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoverageInstrumentingProcessor.class);
    private final Instrumentor decorator;
    private final Set<String> excludes;
    private final CoverageAccumulator accumulator;

    @Inject
    public CoverageInstrumentingProcessor(Instrumentor decorator, @Coverage(value="coverageExcludes") Set<String> excludes, CoverageAccumulator accumulator) {
        this.decorator = decorator;
        this.excludes = excludes;
        this.accumulator = accumulator;
    }

    public FileInfo process(FileInfo file) {
        if (file.getFileName().contains("LCOV.js") || !file.canLoad() || file.isServeOnly() || this.excludes.contains(file.getFileName())) {
            return file;
        }
        long start = System.currentTimeMillis();
        InstrumentedCode decorated = this.decorator.instrument(new Code(file.getFileName(), file.getData()));
        LOGGER.debug(String.format("Instrumented %s in %ss", file.getFileName(), (double)(System.currentTimeMillis() - start) / 1000.0));
        decorated.writeInitialLines(this.accumulator);
        return new FileInfo(file.getFileName(), file.getTimestamp(), file.isPatch(), file.isServeOnly(), decorated.getInstrumentedCode());
    }
}

