/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty9.util.thread;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.seleniumhq.jetty9.util.component.AbstractLifeCycle;
import org.seleniumhq.jetty9.util.thread.ThreadPool;
import org.seleniumhq.jetty9.util.thread.ThreadPoolBudget;

public class ExecutorSizedThreadPool
extends AbstractLifeCycle
implements ThreadPool.SizedThreadPool {
    private final ThreadPoolExecutor executor;

    public ExecutorSizedThreadPool() {
        this(new ThreadPoolExecutor(8, 200, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()));
    }

    public ExecutorSizedThreadPool(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    @Override
    public int getMinThreads() {
        return this.executor.getCorePoolSize();
    }

    @Override
    public int getMaxThreads() {
        return this.executor.getMaximumPoolSize();
    }

    @Override
    public void setMinThreads(int threads) {
        this.executor.setCorePoolSize(threads);
    }

    @Override
    public void setMaxThreads(int threads) {
        this.executor.setMaximumPoolSize(threads);
    }

    @Override
    public int getThreads() {
        return this.executor.getPoolSize();
    }

    @Override
    public int getIdleThreads() {
        return this.getThreads() - this.executor.getActiveCount();
    }

    @Override
    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    @Override
    public boolean isLowOnThreads() {
        return this.getThreads() == this.getMaxThreads() && this.executor.getQueue().size() >= this.getIdleThreads();
    }

    @Override
    protected void doStop() throws Exception {
        this.executor.shutdownNow();
    }

    @Override
    public void join() throws InterruptedException {
        this.executor.awaitTermination(this.getStopTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public ThreadPoolBudget getThreadPoolBudget() {
        return new ThreadPoolBudget(this);
    }
}

