/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.io.CharSource;
import com.google.common.io.CharStreams;
import com.google.common.io.FileBackedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.session.CapabilitiesFilter;
import org.openqa.selenium.remote.session.CapabilityTransform;
import org.openqa.selenium.remote.session.ChromeFilter;
import org.openqa.selenium.remote.session.EdgeFilter;
import org.openqa.selenium.remote.session.FirefoxFilter;
import org.openqa.selenium.remote.session.InternetExplorerFilter;
import org.openqa.selenium.remote.session.OperaFilter;
import org.openqa.selenium.remote.session.ProxyTransform;
import org.openqa.selenium.remote.session.SafariFilter;
import org.openqa.selenium.remote.session.StripAnyPlatform;
import org.openqa.selenium.remote.session.W3CPlatformNameNormaliser;

public class NewSessionPayload
implements Closeable {
    private final Set<CapabilitiesFilter> adapters;
    private final Set<CapabilityTransform> transforms;
    private static final Dialect DEFAULT_DIALECT = Dialect.OSS;
    private static final Predicate<String> ACCEPTED_W3C_PATTERNS = Stream.of("^[\\w-]+:.*$", "^acceptInsecureCerts$", "^browserName$", "^browserVersion$", "^platformName$", "^pageLoadStrategy$", "^proxy$", "^setWindowRect$", "^timeouts$", "^unhandledPromptBehavior$").map(Pattern::compile).map(Pattern::asPredicate).reduce(identity -> false, Predicate::or);
    private final Json json = new Json();
    private final FileBackedOutputStream backingStore;
    private final ImmutableSet<Dialect> dialects;

    public static NewSessionPayload create(Capabilities caps) throws IOException {
        return NewSessionPayload.create(ImmutableMap.of("desiredCapabilities", caps.asMap()));
    }

    public static NewSessionPayload create(Map<String, ?> source) throws IOException {
        Objects.requireNonNull(source, "Payload must be set");
        String json = new Json().toJson(source);
        return new NewSessionPayload(new StringReader(json));
    }

    public static NewSessionPayload create(Reader source) throws IOException {
        return new NewSessionPayload(source);
    }

    private NewSessionPayload(Reader source) throws IOException {
        int threshold = (int)Math.min(Integer.MAX_VALUE, Math.min(Runtime.getRuntime().freeMemory() / 5L, Runtime.getRuntime().maxMemory() / 10L));
        this.backingStore = new FileBackedOutputStream(threshold);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.backingStore, StandardCharsets.UTF_8);){
            CharStreams.copy(source, writer);
        }
        ImmutableSet.Builder adapters = ImmutableSet.builder();
        ServiceLoader.load(CapabilitiesFilter.class).forEach(adapters::add);
        ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)adapters.add(new ChromeFilter())).add(new EdgeFilter())).add(new FirefoxFilter())).add(new InternetExplorerFilter())).add(new OperaFilter())).add(new SafariFilter());
        this.adapters = adapters.build();
        ImmutableSet.Builder transforms = ImmutableSet.builder();
        ServiceLoader.load(CapabilityTransform.class).forEach(transforms::add);
        ((ImmutableSet.Builder)((ImmutableSet.Builder)transforms.add(new ProxyTransform())).add(new StripAnyPlatform())).add(new W3CPlatformNameNormaliser());
        this.transforms = transforms.build();
        ImmutableSet.Builder dialects = ImmutableSet.builder();
        if (this.getOss() != null) {
            dialects.add((Object)Dialect.OSS);
        }
        if (this.getAlwaysMatch() != null || this.getFirstMatches() != null) {
            dialects.add((Object)Dialect.W3C);
        }
        this.dialects = dialects.build();
        this.validate();
    }

    private void validate() throws IOException {
        Map<String, Object> alwaysMatch = this.getAlwaysMatch();
        if (alwaysMatch == null) {
            alwaysMatch = ImmutableMap.of();
        }
        Map<String, Object> always = alwaysMatch;
        Collection<Map<String, Object>> firsts = this.getFirstMatches();
        if (firsts == null) {
            firsts = ImmutableList.of(ImmutableMap.of());
        }
        if (firsts.isEmpty()) {
            throw new IllegalArgumentException("First match w3c capabilities is zero length");
        }
        firsts.stream().peek(map -> {
            Sets.SetView overlap = Sets.intersection(always.keySet(), map.keySet());
            if (!overlap.isEmpty()) {
                throw new IllegalArgumentException("Overlapping keys between w3c always and first match capabilities: " + overlap);
            }
        }).map(first -> {
            HashMap toReturn = new HashMap();
            toReturn.putAll(always);
            toReturn.putAll(first);
            return toReturn;
        }).peek(map -> {
            ImmutableSortedSet nullKeys = map.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(ImmutableSortedSet.toImmutableSortedSet(Ordering.natural()));
            if (!nullKeys.isEmpty()) {
                throw new IllegalArgumentException("Null values found in w3c capabilities. Keys are: " + nullKeys);
            }
        }).peek(map -> {
            ImmutableSortedSet illegalKeys = map.entrySet().stream().filter(entry -> !ACCEPTED_W3C_PATTERNS.test((String)entry.getKey())).map(Map.Entry::getKey).collect(ImmutableSortedSet.toImmutableSortedSet(Ordering.natural()));
            if (!illegalKeys.isEmpty()) {
                throw new IllegalArgumentException("Illegal key values seen in w3c capabilities: " + illegalKeys);
            }
        }).forEach(map -> {});
    }

    public void writeTo(Appendable appendable) throws IOException {
        try (JsonOutput json = new Json().newOutput(appendable);){
            json.beginObject();
            Map<String, Object> first = this.getOss();
            if (first == null) {
                first = this.stream().findFirst().orElse(new ImmutableCapabilities()).asMap();
            }
            json.name("desiredCapabilities");
            json.write(first);
            json.name("capabilities");
            json.beginObject();
            json.name("desiredCapabilities");
            json.write(first);
            json.name("firstMatch");
            json.beginArray();
            this.getW3C().forEach(json::write);
            json.endArray();
            json.endObject();
            this.writeMetaData(json);
            json.endObject();
        }
    }

    private void writeMetaData(JsonOutput out) throws IOException {
        CharSource charSource = this.backingStore.asByteSource().asCharSource(StandardCharsets.UTF_8);
        try (BufferedReader reader = charSource.openBufferedStream();
             JsonInput input = this.json.newInput(reader);){
            input.beginObject();
            block26: while (input.hasNext()) {
                String name;
                switch (name = input.nextName()) {
                    case "capabilities": 
                    case "desiredCapabilities": 
                    case "requiredCapabilities": {
                        input.skipValue();
                        continue block26;
                    }
                }
                out.name(name);
                out.write(input.read((Type)((Object)Object.class)));
            }
        }
    }

    public Stream<Capabilities> stream() throws IOException {
        Stream<Map<String, Object>> oss = Stream.of(this.getOss());
        Stream<Map<String, Object>> w3c = this.getW3C();
        return Stream.concat(oss, w3c).filter(Objects::nonNull).map(this::applyTransforms).filter(Objects::nonNull).distinct().map(ImmutableCapabilities::new);
    }

    public ImmutableSet<Dialect> getDownstreamDialects() {
        return this.dialects.isEmpty() ? ImmutableSet.of(DEFAULT_DIALECT) : this.dialects;
    }

    @Override
    public void close() throws IOException {
        this.backingStore.reset();
    }

    private Map<String, Object> getOss() throws IOException {
        CharSource charSource = this.backingStore.asByteSource().asCharSource(StandardCharsets.UTF_8);
        try (BufferedReader reader = charSource.openBufferedStream();
             JsonInput input = this.json.newInput(reader);){
            input.beginObject();
            while (input.hasNext()) {
                String name = input.nextName();
                if ("desiredCapabilities".equals(name)) {
                    Map map = (Map)input.read(Json.MAP_TYPE);
                    return map;
                }
                input.skipValue();
            }
        }
        return null;
    }

    private Stream<Map<String, Object>> getW3C() throws IOException {
        Stream<Map> fromW3c;
        Stream<Map> fromOss;
        Map<String, Object> oss = this.convertOssToW3C(this.getOss());
        if (oss != null) {
            HashSet usedKeys = new HashSet();
            ImmutableList firsts = this.adapters.stream().map(adapter -> adapter.apply(oss)).filter(Objects::nonNull).filter(map -> !map.isEmpty()).map(map -> map.entrySet().stream().filter(entry -> entry.getKey() != null).filter(entry -> ACCEPTED_W3C_PATTERNS.test((String)entry.getKey())).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).peek(map -> usedKeys.addAll(map.keySet())).collect(ImmutableList.toImmutableList());
            if (firsts.isEmpty()) {
                firsts = ImmutableList.of(ImmutableMap.of());
            }
            Map always = oss.entrySet().stream().filter(entry -> !usedKeys.contains(entry.getKey())).filter(entry -> entry.getValue() != null).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            fromOss = firsts.stream().map(first -> ImmutableMap.builder().putAll(always).putAll(first).build()).map(this::applyTransforms).map(map -> map.entrySet().stream().filter(entry -> ACCEPTED_W3C_PATTERNS.test((String)entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
        } else {
            fromOss = Stream.of(new Map[0]);
        }
        Map<String, Object> alwaysMatch = this.getAlwaysMatch();
        Collection<Map<String, Object>> firsts = this.getFirstMatches();
        if (alwaysMatch == null && firsts == null) {
            fromW3c = Stream.of(new Map[0]);
        } else {
            if (alwaysMatch == null) {
                alwaysMatch = ImmutableMap.of();
            }
            Map<String, Object> always = alwaysMatch;
            if (firsts == null) {
                firsts = ImmutableList.of(ImmutableMap.of());
            }
            fromW3c = firsts.stream().map(first -> ImmutableMap.builder().putAll(always).putAll(first).build());
        }
        return Stream.concat(fromOss, fromW3c).distinct();
    }

    private Map<String, Object> convertOssToW3C(Map<String, Object> capabilities) {
        if (capabilities == null) {
            return null;
        }
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        toReturn.putAll(capabilities);
        if (capabilities.containsKey("platform") && !capabilities.containsKey("platformName")) {
            toReturn.put("platformName", String.valueOf(capabilities.get("platform")));
        }
        return toReturn;
    }

    private Map<String, Object> getAlwaysMatch() throws IOException {
        CharSource charSource = this.backingStore.asByteSource().asCharSource(StandardCharsets.UTF_8);
        try (BufferedReader reader = charSource.openBufferedStream();
             JsonInput input = this.json.newInput(reader);){
            input.beginObject();
            while (input.hasNext()) {
                String name = input.nextName();
                if ("capabilities".equals(name)) {
                    input.beginObject();
                    while (input.hasNext()) {
                        name = input.nextName();
                        if ("alwaysMatch".equals(name)) {
                            Map map = (Map)input.read(Json.MAP_TYPE);
                            return map;
                        }
                        input.skipValue();
                    }
                    input.endObject();
                    continue;
                }
                input.skipValue();
            }
        }
        return null;
    }

    private Collection<Map<String, Object>> getFirstMatches() throws IOException {
        CharSource charSource = this.backingStore.asByteSource().asCharSource(StandardCharsets.UTF_8);
        try (BufferedReader reader = charSource.openBufferedStream();
             JsonInput input = this.json.newInput(reader);){
            input.beginObject();
            while (input.hasNext()) {
                String name = input.nextName();
                if ("capabilities".equals(name)) {
                    input.beginObject();
                    while (input.hasNext()) {
                        name = input.nextName();
                        if ("firstMatch".equals(name)) {
                            Collection collection = (Collection)input.read(Json.LIST_OF_MAPS_TYPE);
                            return collection;
                        }
                        input.skipValue();
                    }
                    input.endObject();
                    continue;
                }
                input.skipValue();
            }
        }
        return null;
    }

    private Map<String, Object> applyTransforms(Map<String, Object> caps) {
        LinkedList<Map.Entry<String, Object>> toExamine = new LinkedList<Map.Entry<String, Object>>();
        toExamine.addAll(caps.entrySet());
        HashSet seenKeys = new HashSet();
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        block0: while (!toExamine.isEmpty()) {
            Map.Entry<String, Object> entry = (Map.Entry<String, Object>)toExamine.remove();
            seenKeys.add(entry.getKey());
            if (entry.getValue() == null) continue;
            for (CapabilityTransform transform : this.transforms) {
                Collection<Map.Entry<String, Object>> result = transform.apply(entry);
                if (result == null) {
                    toReturn.remove(entry.getKey());
                    continue block0;
                }
                for (Map.Entry<String, Object> newEntry : result) {
                    if (!seenKeys.contains(newEntry.getKey())) {
                        toExamine.add(newEntry);
                        continue;
                    }
                    if (newEntry.getKey().equals(entry.getKey())) {
                        entry = newEntry;
                    }
                    toReturn.put(newEntry.getKey(), newEntry.getValue());
                }
            }
        }
        return toReturn;
    }
}

