/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.json.BooleanCoercer;
import org.openqa.selenium.json.CollectionCoercer;
import org.openqa.selenium.json.CommandCoercer;
import org.openqa.selenium.json.EnumCoercer;
import org.openqa.selenium.json.InstanceCoercer;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonType;
import org.openqa.selenium.json.MapCoercer;
import org.openqa.selenium.json.NumberCoercer;
import org.openqa.selenium.json.ObjectCoercer;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.ResponseCoercer;
import org.openqa.selenium.json.SessionIdCoercer;
import org.openqa.selenium.json.StaticInitializerCoercer;
import org.openqa.selenium.json.StringCoercer;
import org.openqa.selenium.json.TypeCoercer;
import org.openqa.selenium.json.Types;

class JsonTypeCoercer {
    private final Set<TypeCoercer<?>> additionalCoercers;
    private final Set<TypeCoercer> coercers;
    private final Map<Type, BiFunction<JsonInput, PropertySetting, Object>> knownCoercers = new ConcurrentHashMap<Type, BiFunction<JsonInput, PropertySetting, Object>>();

    JsonTypeCoercer() {
        this(ImmutableSet.of());
    }

    JsonTypeCoercer(JsonTypeCoercer coercer, Iterable<TypeCoercer<?>> coercers) {
        this(((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(coercers)).addAll(coercer.additionalCoercers)).build());
    }

    JsonTypeCoercer(Iterable<TypeCoercer<?>> coercers) {
        this.additionalCoercers = ImmutableSet.copyOf(coercers);
        this.coercers = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(coercers)).add(new BooleanCoercer())).add(new NumberCoercer<Byte>(Byte.class, Byte::parseByte))).add(new NumberCoercer<Double>(Double.class, Double::parseDouble))).add(new NumberCoercer<Float>(Float.class, Float::parseFloat))).add(new NumberCoercer<Integer>(Integer.class, Integer::parseInt))).add(new NumberCoercer<Long>(Long.class, Long::parseLong))).add(new NumberCoercer<Number>(Number.class, str -> {
            if (str.indexOf(46) != -1) {
                return Double.parseDouble(str);
            }
            return Long.parseLong(str);
        }))).add(new NumberCoercer<Short>(Short.class, Short::parseShort))).add(new StringCoercer())).add(new EnumCoercer())).add(new MapCoercer<MutableCapabilities>(Capabilities.class, this, Collector.of(MutableCapabilities::new, (caps, entry) -> caps.setCapability((String)entry.getKey(), entry.getValue()), MutableCapabilities::merge, Collector.Characteristics.UNORDERED)))).add(new CommandCoercer())).add(new ResponseCoercer(this))).add(new SessionIdCoercer())).add(new CollectionCoercer<List>(List.class, this, Collectors.toCollection(ArrayList::new)))).add(new CollectionCoercer<Set>(Set.class, this, Collectors.toCollection(HashSet::new)))).add(new MapCoercer<LinkedHashMap>(Map.class, this, Collector.of(LinkedHashMap::new, (map, entry) -> map.put(entry.getKey(), entry.getValue()), (l, r) -> {
            l.putAll(r);
            return l;
        }, Collector.Characteristics.UNORDERED, Collector.Characteristics.CONCURRENT)))).add(new ObjectCoercer(this))).add(new StaticInitializerCoercer())).add(new InstanceCoercer(this))).build();
    }

    <T> T coerce(JsonInput json, Type typeOfT, PropertySetting setter) {
        BiFunction coercer = this.knownCoercers.computeIfAbsent(typeOfT, this::buildCoercer);
        Object result = Objects.requireNonNull(coercer).apply(json, setter);
        return (T)result;
    }

    private BiFunction<JsonInput, PropertySetting, Object> buildCoercer(Type type) {
        return this.coercers.stream().filter(coercer -> coercer.test(Types.narrow(type))).findFirst().map(coercer -> coercer.apply(type)).map(func -> (jsonInput, setter) -> {
            if (jsonInput.peek() == JsonType.NULL) {
                jsonInput.skipValue();
                return null;
            }
            return func.apply(jsonInput, setter);
        }).orElseThrow(() -> new JsonException("Unable to find type coercer for " + type));
    }
}

