/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.Closeable;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonType;
import org.openqa.selenium.json.JsonTypeCoercer;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.TypeCoercer;

public class JsonInput
implements Closeable {
    private final JsonReader jsonReader;
    private volatile boolean readPerformed = false;
    private volatile JsonTypeCoercer coercer;
    private volatile PropertySetting setter;

    JsonInput(JsonReader jsonReader, JsonTypeCoercer coercer) {
        this.jsonReader = jsonReader;
        this.coercer = coercer;
        this.setter = PropertySetting.BY_NAME;
    }

    public JsonInput propertySetting(PropertySetting setter) {
        if (this.readPerformed) {
            throw new JsonException("JsonInput has already been used and may not be modified");
        }
        this.setter = Objects.requireNonNull(setter);
        return this;
    }

    public JsonInput addCoercers(TypeCoercer<?> ... coercers) {
        return this.addCoercers(Arrays.asList(coercers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonInput addCoercers(Iterable<TypeCoercer<?>> coercers) {
        JsonInput jsonInput = this;
        synchronized (jsonInput) {
            if (this.readPerformed) {
                throw new JsonException("JsonInput has already been used and may not be modified");
            }
            this.coercer = new JsonTypeCoercer(this.coercer, coercers);
        }
        return this;
    }

    @Override
    public void close() {
        this.execute(this.jsonReader::close);
    }

    public JsonType peek() {
        return this.execute(() -> {
            JsonToken token = this.jsonReader.peek();
            switch (token) {
                case BEGIN_ARRAY: {
                    return JsonType.START_COLLECTION;
                }
                case BEGIN_OBJECT: {
                    return JsonType.START_MAP;
                }
                case BOOLEAN: {
                    return JsonType.BOOLEAN;
                }
                case NAME: {
                    return JsonType.NAME;
                }
                case NULL: {
                    return JsonType.NULL;
                }
                case NUMBER: {
                    return JsonType.NUMBER;
                }
                case STRING: {
                    return JsonType.STRING;
                }
            }
            throw new JsonException("Unrecognized underlying type: " + (Object)((Object)token));
        });
    }

    public void beginObject() {
        this.execute(this.jsonReader::beginObject);
    }

    public void endObject() {
        this.execute(this.jsonReader::endObject);
    }

    public void beginArray() {
        this.execute(this.jsonReader::beginArray);
    }

    public void endArray() {
        this.execute(this.jsonReader::endArray);
    }

    public boolean hasNext() {
        return this.execute(this.jsonReader::hasNext);
    }

    public Boolean nextBoolean() {
        return this.execute(this.jsonReader::nextBoolean);
    }

    public String nextName() {
        return this.execute(this.jsonReader::nextName);
    }

    public Number nextNumber() {
        return this.execute(() -> {
            if (this.jsonReader.peek() != JsonToken.NUMBER) {
                throw new JsonException("Expected number but was: " + (Object)((Object)this.peek()));
            }
            String raw = this.jsonReader.nextString();
            if (raw.contains(".")) {
                return Double.parseDouble(raw);
            }
            return Long.parseLong(raw);
        });
    }

    public String nextString() {
        return this.execute(() -> {
            if (this.jsonReader.peek() == JsonToken.NULL) {
                this.jsonReader.nextNull();
                return null;
            }
            return this.jsonReader.nextString();
        });
    }

    public <T> T read(Type type) {
        return this.coercer.coerce(this, type, this.setter);
    }

    public void skipValue() {
        this.execute(this.jsonReader::skipValue);
    }

    private <T> T execute(Callable<T> callable) {
        this.readPerformed = true;
        try {
            return callable.call();
        }
        catch (JsonParseException e) {
            throw new JsonException(e);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    private static interface VoidCallable
    extends Callable<Void> {
        public void execute() throws Exception;

        @Override
        default public Void call() throws Exception {
            this.execute();
            return null;
        }
    }
}

