/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collector;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.SimplePropertyDescriptor;
import org.openqa.selenium.logging.LogLevelMapping;
import org.openqa.selenium.remote.SessionId;

class BeanToJsonConverter {
    private static final int MAX_DEPTH = 5;
    private final Gson gson;
    private final Map<Predicate<Class<?>>, BiFunction<Integer, Object, JsonElement>> converters;

    public BeanToJsonConverter() {
        this(Json.GSON);
    }

    public BeanToJsonConverter(Gson gson) {
        this.gson = gson;
        this.converters = ImmutableMap.builder().put(Boolean.class::isAssignableFrom, (depth, o) -> new JsonPrimitive((Boolean)o)).put(CharSequence.class::isAssignableFrom, (depth, o) -> new JsonPrimitive(String.valueOf(o))).put(Date.class::isAssignableFrom, (depth, o) -> new JsonPrimitive(TimeUnit.MILLISECONDS.toSeconds(((Date)o).getTime()))).put(Enum.class::isAssignableFrom, (depth, o) -> new JsonPrimitive(o.toString())).put(File.class::isAssignableFrom, (depth, o) -> new JsonPrimitive(((File)o).getAbsolutePath())).put(Number.class::isAssignableFrom, (depth, o) -> new JsonPrimitive((Number)o)).put(URL.class::isAssignableFrom, (depth, o) -> new JsonPrimitive(((URL)o).toExternalForm())).put(JsonElement.class::isAssignableFrom, (depth, o) -> (JsonElement)o).put(Level.class::isAssignableFrom, (depth, o) -> new JsonPrimitive(LogLevelMapping.getName((Level)o))).put(SessionId.class::isAssignableFrom, (depth, o) -> {
            JsonObject converted = new JsonObject();
            converted.addProperty("value", o.toString());
            return converted;
        }).put(cls -> this.getMethod((Class<?>)cls, "toJson") != null, (depth, o) -> this.convertUsingMethod("toJson", o, (int)depth)).put(cls -> this.getMethod((Class<?>)cls, "asMap") != null, (depth, o) -> this.convertUsingMethod("asMap", o, (int)depth)).put(cls -> this.getMethod((Class<?>)cls, "toMap") != null, (depth, o) -> this.convertUsingMethod("toMap", o, (int)depth)).put(Collection.class::isAssignableFrom, (depth, o) -> ((Collection)o).stream().map(obj -> this.convertObject(obj, depth - 1)).collect(Collector.of(JsonArray::new, JsonArray::add, (l, r) -> {
            l.addAll((JsonArray)r);
            return l;
        }, new Collector.Characteristics[0]))).put(Map.class::isAssignableFrom, (depth, o) -> {
            JsonObject converted = new JsonObject();
            ((Map)o).forEach((key, value) -> converted.add(String.valueOf(key), this.convertObject(value, depth - 1)));
            return converted;
        }).put(Class::isArray, (depth, o) -> {
            JsonArray converted = new JsonArray();
            Arrays.stream((Object[])o).forEach(value -> converted.add(this.convertObject(value, depth - 1)));
            return converted;
        }).put(cls -> true, (depth, o) -> this.mapObject(o, depth - 1)).build();
    }

    public String convert(Object object) {
        if (object == null) {
            return null;
        }
        try {
            JsonElement json = this.convertObject(object, 5);
            return this.gson.toJson(json);
        }
        catch (WebDriverException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebDriverException("Unable to convert: " + object, e);
        }
    }

    @Deprecated
    JsonElement convertObject(Object object) {
        return this.convertObject(object, 5);
    }

    private JsonElement convertObject(Object toConvert, int maxDepth) {
        if (toConvert == null) {
            return JsonNull.INSTANCE;
        }
        return this.converters.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(toConvert.getClass())).map(Map.Entry::getValue).findFirst().map(to -> (JsonElement)to.apply(maxDepth, toConvert)).orElse(null);
    }

    private Method getMethod(Class<?> clazz, String methodName) {
        try {
            Method method = clazz.getMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException | SecurityException exception) {
            return null;
        }
    }

    private JsonElement convertUsingMethod(String methodName, Object toConvert, int depth) {
        try {
            Method method = this.getMethod(toConvert.getClass(), methodName);
            Object value = method.invoke(toConvert, new Object[0]);
            return this.convertObject(value, depth);
        }
        catch (ReflectiveOperationException e) {
            throw new WebDriverException(e);
        }
    }

    private JsonElement mapObject(Object toConvert, int maxDepth) {
        if (maxDepth < 1) {
            return JsonNull.INSTANCE;
        }
        JsonObject mapped = new JsonObject();
        for (SimplePropertyDescriptor pd : SimplePropertyDescriptor.getPropertyDescriptors(toConvert.getClass())) {
            if ("class".equals(pd.getName())) {
                mapped.addProperty("class", toConvert.getClass().getName());
                continue;
            }
            Method readMethod = pd.getReadMethod();
            if (readMethod == null || Object.class.equals(readMethod.getDeclaringClass()) || readMethod.getParameterTypes().length > 0) continue;
            readMethod.setAccessible(true);
            try {
                Object result = readMethod.invoke(toConvert, new Object[0]);
                mapped.add(pd.getName(), this.convertObject(result, maxDepth - 1));
            }
            catch (ReflectiveOperationException e) {
                throw new WebDriverException(e);
            }
        }
        return mapped;
    }
}

