/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils.configuration;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.Expose;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.grid.common.GridConfiguredJson;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.listeners.Prioritizer;
import org.openqa.grid.internal.utils.CapabilityMatcher;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeCoercer;

public class StandaloneConfiguration {
    public static final String DEFAULT_STANDALONE_CONFIG_FILE = "org/openqa/grid/common/defaults/DefaultStandalone.json";
    @VisibleForTesting
    static final Integer DEFAULT_TIMEOUT = 1800;
    @VisibleForTesting
    static final Integer DEFAULT_BROWSER_TIMEOUT = 0;
    @VisibleForTesting
    static final String DEFAULT_ROLE = "standalone";
    @VisibleForTesting
    static final Integer DEFAULT_PORT = 4444;
    @VisibleForTesting
    static final Boolean DEFAULT_DEBUG_TOGGLE = false;
    @Expose(serialize=false)
    private transient boolean avoidProxy;
    @Expose(serialize=false)
    private transient boolean browserSideLog;
    @Expose(serialize=false)
    private transient boolean captureLogsOnQuit;
    @Expose
    public Integer browserTimeout = DEFAULT_BROWSER_TIMEOUT;
    @Expose
    public Boolean debug = DEFAULT_DEBUG_TOGGLE;
    @Expose
    public Integer jettyMaxThreads;
    @Expose
    public String log;
    @Expose
    public String host;
    @Expose
    public Integer port = DEFAULT_PORT;
    @Expose
    public String role = "standalone";
    @Expose
    public Integer timeout = DEFAULT_TIMEOUT;

    public static <T extends StandaloneConfiguration> T loadFromJson(String resource, Class<T> type) {
        try (JsonInput jsonInput = StandaloneConfiguration.loadJsonFromResourceOrFile(resource);){
            T t = StandaloneConfiguration.loadFromJson(jsonInput, type);
            return t;
        }
    }

    public static <T extends StandaloneConfiguration> T loadFromJson(JsonInput jsonInput, Class<T> type) {
        try {
            return (T)((StandaloneConfiguration)GridConfiguredJson.toType(jsonInput, type));
        }
        catch (GridConfigurationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new GridConfigurationException(e.getMessage(), e);
        }
    }

    protected Collection<TypeCoercer<?>> getCoercers() {
        return ImmutableSet.of();
    }

    public void merge(StandaloneConfiguration other) {
        if (other == null) {
            return;
        }
        if (this.isMergeAble(Integer.class, other.browserTimeout, this.browserTimeout)) {
            this.browserTimeout = other.browserTimeout;
        }
        if (this.isMergeAble(Integer.class, other.jettyMaxThreads, this.jettyMaxThreads)) {
            this.jettyMaxThreads = other.jettyMaxThreads;
        }
        if (this.isMergeAble(Integer.class, other.timeout, this.timeout)) {
            this.timeout = other.timeout;
        }
    }

    protected boolean isMergeAble(Class<?> targetType, Object other, Object target) {
        if (other == null) {
            return false;
        }
        if (target == null) {
            return true;
        }
        if (!targetType.isAssignableFrom(target.getClass()) || !targetType.isAssignableFrom(other.getClass())) {
            return false;
        }
        if (target instanceof Collection) {
            return !((Collection)other).isEmpty();
        }
        if (target instanceof Map) {
            return !((Map)other).isEmpty();
        }
        return true;
    }

    public String toString(String format) {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.toString(format, "browserTimeout", this.browserTimeout));
        sb.append((CharSequence)this.toString(format, "debug", this.debug));
        sb.append((CharSequence)this.toString(format, "jettyMaxThreads", this.jettyMaxThreads));
        sb.append((CharSequence)this.toString(format, "log", this.log));
        sb.append((CharSequence)this.toString(format, "host", this.host));
        sb.append((CharSequence)this.toString(format, "port", this.port));
        sb.append((CharSequence)this.toString(format, "role", this.role));
        sb.append((CharSequence)this.toString(format, "timeout", this.timeout));
        return sb.toString();
    }

    public String toString() {
        return this.toString(" -%1$s %2$s");
    }

    public StringBuilder toString(String format, String name, Object value) {
        StringBuilder sb = new StringBuilder();
        List<Object> iterator = value instanceof List ? (List<Object>)value : Arrays.asList(value);
        for (Object e : iterator) {
            if (e == null || e instanceof Map && ((Map)e).isEmpty() || e instanceof Collection && ((Collection)e).isEmpty()) continue;
            sb.append(String.format(format, name, e));
        }
        return sb;
    }

    public Map<String, Object> toJson() {
        HashSet<Field> fields = new HashSet<Field>();
        Class<?> current = this.getClass();
        while (!current.equals(Object.class)) {
            fields.addAll(Arrays.asList(current.getDeclaredFields()));
            current = current.getSuperclass();
        }
        return fields.stream().filter(field -> field.getAnnotation(Expose.class) != null).filter(field -> field.getAnnotation(Expose.class).serialize()).peek(field -> field.setAccessible(true)).map(field -> {
            try {
                Object value = field.get(this);
                if (value instanceof CapabilityMatcher || value instanceof Prioritizer) {
                    value = value.getClass().getName();
                }
                return new AbstractMap.SimpleImmutableEntry<String, Object>(field.getName(), value);
            }
            catch (ReflectiveOperationException e) {
                throw new WebDriverException(e);
            }
        }).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    protected static JsonInput loadJsonFromResourceOrFile(String resource) {
        try {
            return new Json().newInput(StandaloneConfiguration.readFileOrResource(resource));
        }
        catch (RuntimeException e) {
            throw new GridConfigurationException("Unable to read input", e);
        }
    }

    private static Reader readFileOrResource(String resource) {
        Stream<Function> suppliers = Stream.of(path -> {
            try {
                return new FileInputStream((String)path);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }, path -> Thread.currentThread().getContextClassLoader().getResourceAsStream("org/openqa/grid/common/" + path), path -> Thread.currentThread().getContextClassLoader().getResourceAsStream((String)path), path -> new ByteArrayInputStream(path.getBytes()));
        InputStream in = suppliers.map(supplier -> (InputStream)supplier.apply(resource)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new RuntimeException(resource + " is not a valid resource."));
        return new BufferedReader(new InputStreamReader(in));
    }
}

