/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils.configuration;

import com.google.gson.annotations.Expose;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openqa.grid.common.SeleniumProtocol;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.utils.configuration.GridConfiguration;
import org.openqa.grid.internal.utils.configuration.StandaloneConfiguration;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.net.NetworkUtils;

public class GridNodeConfiguration
extends GridConfiguration {
    public static final String DEFAULT_NODE_CONFIG_FILE = "org/openqa/grid/common/defaults/DefaultNodeWebDriver.json";
    public static final String CONFIG_UUID_CAPABILITY = "server:CONFIG_UUID";
    static final String DEFAULT_ROLE = "node";
    static final Integer DEFAULT_PORT = -1;
    static final Integer DEFAULT_POLLING_INTERVAL = 5000;
    static final Integer DEFAULT_MAX_SESSION = 5;
    static final Integer DEFAULT_REGISTER_CYCLE = 5000;
    static final Boolean DEFAULT_REGISTER_TOGGLE = true;
    static final String DEFAULT_HUB = "http://localhost:4444";
    static final Integer DEFAULT_NODE_STATUS_CHECK_TIMEOUT = 5000;
    static final Integer DEFAULT_UNREGISTER_DELAY = 60000;
    static final Integer DEFAULT_DOWN_POLLING_LIMIT = 2;
    static final String DEFAULT_PROXY = "org.openqa.grid.selenium.proxy.DefaultRemoteProxy";
    private HostPort hubHostPort;
    public String nodeConfigFile;
    @Expose
    public String remoteHost;
    @Expose(serialize=false)
    @Deprecated
    private Object configuration;
    @Expose
    public String hubHost;
    @Expose
    public Integer hubPort;
    @Expose
    public String id;
    @Expose
    public List<MutableCapabilities> capabilities = DefaultDesiredCapabilitiesBuilder.getCapabilities();
    @Expose
    public Integer downPollingLimit = DEFAULT_DOWN_POLLING_LIMIT;
    @Expose
    public String hub = "http://localhost:4444";
    @Expose
    public Integer nodePolling = DEFAULT_POLLING_INTERVAL;
    @Expose
    public Integer nodeStatusCheckTimeout = DEFAULT_NODE_STATUS_CHECK_TIMEOUT;
    @Expose
    public String proxy = "org.openqa.grid.selenium.proxy.DefaultRemoteProxy";
    @Expose
    public Boolean register = DEFAULT_REGISTER_TOGGLE;
    @Expose
    public Integer registerCycle = DEFAULT_REGISTER_CYCLE;
    @Expose
    public Integer unregisterIfStillDownAfter = DEFAULT_UNREGISTER_DELAY;
    @Expose
    public boolean enablePlatformVerification = true;

    public GridNodeConfiguration() {
        this.role = DEFAULT_ROLE;
        this.port = DEFAULT_PORT;
        this.maxSession = DEFAULT_MAX_SESSION;
    }

    public String getHubHost() {
        return this.getHubHostPort().host;
    }

    public Integer getHubPort() {
        return this.getHubHostPort().port;
    }

    private HostPort getHubHostPort() {
        if (this.hubHostPort == null) {
            if (this.hub != null) {
                try {
                    URL u = new URL(this.hub);
                    this.hubHostPort = new HostPort(u.getHost(), u.getPort());
                }
                catch (MalformedURLException mURLe) {
                    throw new RuntimeException("-hub must be a valid url: " + this.hub, mURLe);
                }
            }
            if (this.hubHost != null || this.hubPort != null) {
                if (this.hubHost == null) {
                    throw new RuntimeException("You must specify either a -hubHost or -hub parameter.");
                }
                if (this.hubPort == null) {
                    throw new RuntimeException("You must specify either a -hubPort or -hub parameter.");
                }
                this.hubHostPort = new HostPort(this.hubHost, this.hubPort);
            } else {
                try {
                    URL u = new URL(this.hub);
                    this.hubHostPort = new HostPort(u.getHost(), u.getPort());
                }
                catch (MalformedURLException mURLe) {
                    throw new RuntimeException("-hub must be a valid url: " + this.hub, mURLe);
                }
            }
        }
        return this.hubHostPort;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            if (this.host == null) {
                this.host = "localhost";
            }
            if (this.port == null) {
                this.port = 5555;
            }
            this.remoteHost = "http://" + this.host + ":" + this.port;
        }
        return this.remoteHost;
    }

    public void merge(GridNodeConfiguration other) {
        if (other == null) {
            return;
        }
        super.merge(other);
        if (this.isMergeAble(List.class, other.capabilities, this.capabilities)) {
            this.capabilities = other.capabilities;
        }
        if (this.isMergeAble(Integer.class, other.downPollingLimit, this.downPollingLimit)) {
            this.downPollingLimit = other.downPollingLimit;
        }
        if (this.isMergeAble(String.class, other.hub, this.hub)) {
            this.hub = other.hub;
        }
        if (this.isMergeAble(String.class, other.hubHost, this.hubHost)) {
            this.hubHost = other.hubHost;
        }
        if (this.isMergeAble(Integer.class, other.hubPort, this.hubPort)) {
            this.hubPort = other.hubPort;
        }
        if (this.isMergeAble(String.class, other.id, this.id)) {
            this.id = other.id;
        }
        if (this.isMergeAble(Integer.class, other.nodePolling, this.nodePolling)) {
            this.nodePolling = other.nodePolling;
        }
        if (this.isMergeAble(Integer.class, other.nodeStatusCheckTimeout, this.nodeStatusCheckTimeout)) {
            this.nodeStatusCheckTimeout = other.nodeStatusCheckTimeout;
        }
        if (this.isMergeAble(String.class, other.proxy, this.proxy)) {
            this.proxy = other.proxy;
        }
        if (this.isMergeAble(Boolean.class, other.register, this.register)) {
            this.register = other.register;
        }
        if (this.isMergeAble(Integer.class, other.registerCycle, this.registerCycle)) {
            this.registerCycle = other.registerCycle;
        }
        if (this.isMergeAble(String.class, other.remoteHost, this.remoteHost)) {
            this.remoteHost = other.remoteHost;
        }
        if (this.isMergeAble(Integer.class, other.unregisterIfStillDownAfter, this.unregisterIfStillDownAfter)) {
            this.unregisterIfStillDownAfter = other.unregisterIfStillDownAfter;
        }
    }

    @Override
    public String toString(String format) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(format));
        sb.append((CharSequence)this.toString(format, "capabilities", this.capabilities));
        sb.append((CharSequence)this.toString(format, "downPollingLimit", this.downPollingLimit));
        sb.append((CharSequence)this.toString(format, "hub", this.hub));
        sb.append((CharSequence)this.toString(format, "id", this.id));
        sb.append((CharSequence)this.toString(format, "hubHost", this.hubHost));
        sb.append((CharSequence)this.toString(format, "hubPort", this.hubPort));
        sb.append((CharSequence)this.toString(format, "nodeConfigFile", this.nodeConfigFile));
        sb.append((CharSequence)this.toString(format, "nodePolling", this.nodePolling));
        sb.append((CharSequence)this.toString(format, "nodeStatusCheckTimeout", this.nodeStatusCheckTimeout));
        sb.append((CharSequence)this.toString(format, "proxy", this.proxy));
        sb.append((CharSequence)this.toString(format, "register", this.register));
        sb.append((CharSequence)this.toString(format, "registerCycle", this.registerCycle));
        sb.append((CharSequence)this.toString(format, "remoteHost", this.remoteHost));
        sb.append((CharSequence)this.toString(format, "unregisterIfStillDownAfter", this.unregisterIfStillDownAfter));
        return sb.toString();
    }

    public static GridNodeConfiguration loadFromJSON(String filePath) {
        return GridNodeConfiguration.loadFromJSON(StandaloneConfiguration.loadJsonFromResourceOrFile(filePath));
    }

    public static GridNodeConfiguration loadFromJSON(JsonInput jsonInput) {
        try {
            GridNodeConfiguration config = StandaloneConfiguration.loadFromJson(jsonInput, GridNodeConfiguration.class);
            if (config.configuration != null) {
                throw new GridConfigurationException("Deprecated -nodeConfig file encountered.Please update the file to work with Selenium 3.See https://github.com/SeleniumHQ/selenium/wiki/Grid2#configuring-the-nodes-by-json for more details.");
            }
            return config;
        }
        catch (Throwable e) {
            throw new GridConfigurationException("Error with the JSON of the config : " + e.getMessage(), e);
        }
    }

    public void fixUpCapabilities() {
        if (this.capabilities == null) {
            return;
        }
        Platform current = Platform.getCurrent();
        this.capabilities = this.capabilities.stream().peek(cap -> cap.setCapability("platform", Optional.ofNullable(cap.getCapability("platformName")).orElse(Optional.ofNullable(cap.getCapability("platform")).orElse((Object)current)))).peek(cap -> cap.setCapability("platformName", Optional.ofNullable(cap.getCapability("platformName")).orElse(Optional.ofNullable(cap.getCapability("platform")).orElse((Object)current)))).peek(cap -> cap.setCapability("seleniumProtocol", Optional.ofNullable(cap.getCapability("seleniumProtocol")).orElse(SeleniumProtocol.WebDriver.toString()))).peek(cap -> cap.setCapability(CONFIG_UUID_CAPABILITY, UUID.randomUUID().toString())).collect(Collectors.toList());
    }

    public void dropCapabilitiesThatDoesNotMatchCurrentPlatform() {
        if (!this.enablePlatformVerification) {
            return;
        }
        if (this.capabilities == null) {
            return;
        }
        Platform current = Platform.getCurrent();
        Platform currentFamily = Optional.ofNullable(current.family()).orElse(current);
        this.capabilities = this.capabilities.stream().filter(cap -> cap.getPlatform() != null && (cap.getPlatform() == Platform.ANY || cap.getPlatform().is(currentFamily))).collect(Collectors.toList());
    }

    public void fixUpHost() {
        NetworkUtils util = new NetworkUtils();
        if (this.host == null || "ip".equalsIgnoreCase(this.host)) {
            this.host = util.getIp4NonLoopbackAddressOfThisMachine().getHostAddress();
        } else if ("host".equalsIgnoreCase(this.host)) {
            this.host = util.getIp4NonLoopbackAddressOfThisMachine().getHostName();
        }
    }

    private static class HostPort {
        final String host;
        final int port;

        HostPort(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }

    static final class DefaultDesiredCapabilitiesBuilder {
        DefaultDesiredCapabilitiesBuilder() {
        }

        static List<MutableCapabilities> getCapabilities() {
            try (JsonInput jsonInput = StandaloneConfiguration.loadJsonFromResourceOrFile(GridNodeConfiguration.DEFAULT_NODE_CONFIG_FILE);){
                ArrayList<MutableCapabilities> caps = new ArrayList<MutableCapabilities>();
                Map defaults = (Map)jsonInput.read(Json.MAP_TYPE);
                if (defaults == null || !(defaults.get("capabilities") instanceof Collection)) {
                    ArrayList<MutableCapabilities> arrayList = caps;
                    return arrayList;
                }
                for (Object el : (Collection)defaults.get("capabilities")) {
                    Map map = (Map)el;
                    caps.add(new MutableCapabilities(map));
                }
                ArrayList<MutableCapabilities> arrayList = caps;
                return arrayList;
            }
        }
    }
}

