/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.dom.TextRange;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.util.Locale;
import net.sourceforge.htmlunit.corejs.javascript.Function;

@JsxClass(domClass=HtmlBody.class)
public class HTMLBodyElement
extends HTMLElement {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.EDGE})
    public HTMLBodyElement() {
    }

    public void createEventHandlerFromAttribute(String attributeName, String value) {
        if (attributeName.toLowerCase(Locale.ROOT).startsWith("on")) {
            this.createEventHandler(attributeName.substring(2), value);
        }
    }

    @Override
    protected boolean isEventHandlerOnWindow() {
        return true;
    }

    @Override
    public void setDefaults(ComputedCSSStyleDeclaration style) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_BODY_MARGINS_8)) {
            style.setDefaultLocalStyleAttribute("margin", "8px");
            style.setDefaultLocalStyleAttribute("padding", "0px");
        } else {
            style.setDefaultLocalStyleAttribute("margin-left", "8px");
            style.setDefaultLocalStyleAttribute("margin-right", "8px");
            style.setDefaultLocalStyleAttribute("margin-top", "8px");
            style.setDefaultLocalStyleAttribute("margin-bottom", "8px");
        }
    }

    @Override
    public HTMLElement getOffsetParent_js() {
        return null;
    }

    @JsxGetter
    public String getALink() {
        return this.getDomNodeOrDie().getAttribute("aLink");
    }

    @JsxSetter
    public void setALink(String aLink) {
        this.setColorAttribute("aLink", aLink);
    }

    @JsxGetter
    public String getBackground() {
        HtmlElement node = this.getDomNodeOrDie();
        return node.getAttribute("background");
    }

    @JsxSetter
    public void setBackground(String background) {
        this.getDomNodeOrDie().setAttribute("background", background);
    }

    @JsxGetter
    public String getBgColor() {
        return this.getDomNodeOrDie().getAttribute("bgColor");
    }

    @JsxSetter
    public void setBgColor(String bgColor) {
        this.setColorAttribute("bgColor", bgColor);
    }

    @JsxGetter
    public String getLink() {
        return this.getDomNodeOrDie().getAttribute("link");
    }

    @JsxSetter
    public void setLink(String link) {
        this.setColorAttribute("link", link);
    }

    @JsxGetter
    public String getText() {
        return this.getDomNodeOrDie().getAttribute("text");
    }

    @JsxSetter
    public void setText(String text) {
        this.setColorAttribute("text", text);
    }

    @JsxGetter
    public String getVLink() {
        return this.getDomNodeOrDie().getAttribute("vLink");
    }

    @JsxSetter
    public void setVLink(String vLink) {
        this.setColorAttribute("vLink", vLink);
    }

    @Override
    public int getClientWidth() {
        return super.getClientWidth() + 16;
    }

    @Override
    @JsxFunction(value={SupportedBrowser.IE})
    public TextRange createTextRange() {
        return super.createTextRange();
    }

    @JsxGetter
    public Function getOnbeforeunload() {
        return this.getEventHandler("beforeunload");
    }

    @JsxSetter
    public void setOnbeforeunload(Object onbeforeunload) {
        this.setEventHandler("beforeunload", onbeforeunload);
    }

    @JsxGetter
    public Function getOnhashchange() {
        return this.getEventHandler("hashchange");
    }

    @JsxSetter
    public void setOnhashchange(Object onhashchange) {
        this.setEventHandler("hashchange", onhashchange);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public Function getOnlanguagechange() {
        return this.getEventHandler("languagechange");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public void setOnlanguagechange(Object onlanguagechange) {
        this.setEventHandler("languagechange", onlanguagechange);
    }

    @JsxGetter
    public Function getOnmessage() {
        return this.getEventHandler("message");
    }

    @JsxSetter
    public void setOnmessage(Object onmessage) {
        this.setEventHandler("message", onmessage);
    }

    @JsxGetter
    public Function getOnoffline() {
        return this.getEventHandler("offline");
    }

    @JsxSetter
    public void setOnoffline(Object onoffline) {
        this.setEventHandler("offline", onoffline);
    }

    @JsxGetter
    public Function getOnonline() {
        return this.getEventHandler("online");
    }

    @JsxSetter
    public void setOnonline(Object ononline) {
        this.setEventHandler("online", ononline);
    }

    @JsxGetter
    public Function getOnpagehide() {
        return this.getEventHandler("pagehide");
    }

    @JsxSetter
    public void setOnpagehide(Object onpagehide) {
        this.setEventHandler("pagehide", onpagehide);
    }

    @JsxGetter
    public Function getOnpageshow() {
        return this.getEventHandler("pageshow");
    }

    @JsxSetter
    public void setOnpageshow(Object onpageshow) {
        this.setEventHandler("pageshow", onpageshow);
    }

    @JsxGetter
    public Function getOnpopstate() {
        return this.getEventHandler("popstate");
    }

    @JsxSetter
    public void setOnpopstate(Object onpopstate) {
        this.setEventHandler("popstate", onpopstate);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Function getOnrejectionhandled() {
        return this.getEventHandler("rejectionhandled");
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setOnrejectionhandled(Object onrejectionhandled) {
        this.setEventHandler("rejectionhandled", onrejectionhandled);
    }

    @JsxGetter
    public Function getOnstorage() {
        return this.getEventHandler("storage");
    }

    @JsxSetter
    public void setOnstorage(Object onstorage) {
        this.setEventHandler("storage", onstorage);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Function getOnunhandledrejection() {
        return this.getEventHandler("unhandledrejection");
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setOnunhandledrejection(Object onunhandledrejection) {
        this.setEventHandler("unhandledrejection", onunhandledrejection);
    }

    @JsxGetter
    public Function getOnunload() {
        return this.getEventHandler("unload");
    }

    @JsxSetter
    public void setOnunload(Object onunload) {
        this.setEventHandler("unload", onunload);
    }

    @JsxGetter
    public Function getOnafterprint() {
        return this.getEventHandler("afterprint");
    }

    @JsxSetter
    public void setOnafterprint(Object onafterprint) {
        this.setEventHandler("afterprint", onafterprint);
    }

    @JsxGetter
    public Function getOnbeforeprint() {
        return this.getEventHandler("beforeprint");
    }

    @JsxSetter
    public void setOnbeforeprint(Object onbeforeprint) {
        this.setEventHandler("beforeprint", onbeforeprint);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Function getOnmessageerror() {
        return this.getEventHandler("onmessageerror");
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setOnmessageerror(Object onmessageerror) {
        this.setEventHandler("onmessageerror", onmessageerror);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnresize() {
        return super.getOnresize();
    }

    @Override
    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnresize(Object onresize) {
        super.setOnresize(onresize);
    }
}

