/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.html.CharacterDataChangeEvent;
import com.gargoylesoftware.htmlunit.html.CharacterDataChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.dom.MutationRecord;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.NativeObject;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.TopLevel;

@JsxClass
public class MutationObserver
extends SimpleScriptable
implements HtmlAttributeChangeListener,
CharacterDataChangeListener {
    private Function function_;
    private Node node_;
    private boolean childList_;
    private boolean attaributes_;
    private boolean attributeOldValue_;
    private NativeArray attributeFilter_;
    private boolean characterData_;
    private boolean characterDataOldValue_;
    private boolean subtree_;

    public MutationObserver() {
    }

    @JsxConstructor
    public MutationObserver(Function function) {
        this.function_ = function;
    }

    @JsxFunction
    public void observe(Node node, NativeObject options) {
        if (node == null) {
            throw Context.throwAsScriptRuntimeEx(new IllegalArgumentException("Node is undefined"));
        }
        if (options == null) {
            throw Context.throwAsScriptRuntimeEx(new IllegalArgumentException("Options is undefined"));
        }
        this.node_ = node;
        this.attaributes_ = Boolean.TRUE.equals(options.get("attributes"));
        this.attributeOldValue_ = Boolean.TRUE.equals(options.get("attributeOldValue"));
        this.childList_ = Boolean.TRUE.equals(options.get("childList"));
        this.characterData_ = Boolean.TRUE.equals(options.get("characterData"));
        this.characterDataOldValue_ = Boolean.TRUE.equals(options.get("characterDataOldValue"));
        this.subtree_ = Boolean.TRUE.equals(options.get("subtree"));
        this.attributeFilter_ = (NativeArray)options.get("attributeFilter");
        if (!(this.attaributes_ || this.childList_ || this.characterData_)) {
            throw Context.throwAsScriptRuntimeEx(new IllegalArgumentException("One of childList, attributes, od characterData must be set"));
        }
        if (this.attaributes_ && this.node_.getDomNodeOrDie() instanceof HtmlElement) {
            ((HtmlElement)this.node_.getDomNodeOrDie()).addHtmlAttributeChangeListener(this);
        }
        if (this.characterData_) {
            node.getDomNodeOrDie().addCharacterDataChangeListener(this);
        }
    }

    @JsxFunction
    public void disconnect() {
        if (this.attaributes_ && this.node_.getDomNodeOrDie() instanceof HtmlElement) {
            ((HtmlElement)this.node_.getDomNodeOrDie()).removeHtmlAttributeChangeListener(this);
        }
        if (this.characterData_) {
            this.node_.getDomNodeOrDie().removeCharacterDataChangeListener(this);
        }
    }

    @JsxFunction
    public NativeArray takeRecords() {
        return new NativeArray(0L);
    }

    @Override
    public void characterDataChanged(CharacterDataChangeEvent event) {
        ScriptableObject target = (ScriptableObject)event.getCharacterData().getScriptableObject();
        if (this.subtree_ || target == this.node_) {
            final MutationRecord mutationRecord = new MutationRecord();
            final Scriptable scope = this.getParentScope();
            mutationRecord.setParentScope(scope);
            mutationRecord.setPrototype(this.getPrototype(mutationRecord.getClass()));
            mutationRecord.setType("characterData");
            mutationRecord.setTarget(target);
            if (this.characterDataOldValue_) {
                mutationRecord.setOldValue(event.getOldValue());
            }
            Window window = this.getWindow();
            final HtmlPage owningPage = (HtmlPage)window.getDocument().getPage();
            final JavaScriptEngine jsEngine = (JavaScriptEngine)window.getWebWindow().getWebClient().getJavaScriptEngine();
            jsEngine.addPostponedAction(new PostponedAction(owningPage){

                @Override
                public void execute() throws Exception {
                    NativeArray array = new NativeArray(new Object[]{mutationRecord});
                    ScriptRuntime.setBuiltinProtoAndParent(array, scope, TopLevel.Builtins.Array);
                    jsEngine.callFunction(owningPage, MutationObserver.this.function_, scope, MutationObserver.this, new Object[]{array});
                }
            });
        }
    }

    @Override
    public void attributeAdded(HtmlAttributeChangeEvent event) {
    }

    @Override
    public void attributeRemoved(HtmlAttributeChangeEvent event) {
    }

    @Override
    public void attributeReplaced(HtmlAttributeChangeEvent event) {
        HtmlElement target = event.getHtmlElement();
        if (this.subtree_ || target == this.node_.getDomNodeOrDie()) {
            String attributeName = event.getName();
            if (this.attributeFilter_ == null || this.attributeFilter_.contains(attributeName)) {
                final MutationRecord mutationRecord = new MutationRecord();
                final Scriptable scope = this.getParentScope();
                mutationRecord.setParentScope(scope);
                mutationRecord.setPrototype(this.getPrototype(mutationRecord.getClass()));
                mutationRecord.setAttributeName(attributeName);
                mutationRecord.setType("attributes");
                mutationRecord.setTarget((ScriptableObject)target.getScriptableObject());
                if (this.attributeOldValue_) {
                    mutationRecord.setOldValue(event.getValue());
                }
                Window window = this.getWindow();
                final HtmlPage owningPage = (HtmlPage)window.getDocument().getPage();
                final JavaScriptEngine jsEngine = (JavaScriptEngine)window.getWebWindow().getWebClient().getJavaScriptEngine();
                jsEngine.addPostponedAction(new PostponedAction(owningPage){

                    @Override
                    public void execute() throws Exception {
                        NativeArray array = new NativeArray(new Object[]{mutationRecord});
                        ScriptRuntime.setBuiltinProtoAndParent(array, scope, TopLevel.Builtins.Array);
                        jsEngine.callFunction(owningPage, MutationObserver.this.function_, scope, MutationObserver.this, new Object[]{array});
                    }
                });
            }
        }
    }
}

