/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.TopLevel;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.StringUtils;

@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
public class URLSearchParams
extends SimpleScriptable {
    private final List<Map.Entry<String, String>> params_ = new LinkedList<Map.Entry<String, String>>();

    public URLSearchParams() {
    }

    @JsxConstructor
    public URLSearchParams(Object params) {
        if (Undefined.instance == params || null == params) {
            return;
        }
        this.splitQuery(Context.toString(params));
    }

    private void splitQuery(String params) {
        if (StringUtils.isEmpty(params = StringUtils.stripStart(params, "?"))) {
            return;
        }
        String[] parts = StringUtils.split(params, '&');
        for (int i = 0; i < parts.length; ++i) {
            this.params_.add(this.splitQueryParameter(parts[i]));
        }
    }

    private Map.Entry<String, String> splitQueryParameter(String singleParam) {
        int idx = singleParam.indexOf(61);
        if (idx > 0) {
            String key = singleParam.substring(0, idx);
            String value = null;
            if (idx < singleParam.length()) {
                value = singleParam.substring(idx + 1);
            }
            return new AbstractMap.SimpleEntry<String, Object>(key, value);
        }
        String key = singleParam;
        Object value = null;
        return new AbstractMap.SimpleEntry<String, Object>(key, value);
    }

    @JsxFunction
    public void append(String name, String value) {
        this.params_.add(new AbstractMap.SimpleEntry<String, String>(name, value));
    }

    @Override
    @JsxFunction
    public void delete(String name) {
        Iterator<Map.Entry<String, String>> iter = this.params_.iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            if (!entry.getKey().equals(name)) continue;
            iter.remove();
        }
    }

    @JsxFunction
    public String get(String name) {
        for (Map.Entry<String, String> param : this.params_) {
            if (!param.getKey().equals(name)) continue;
            return param.getValue();
        }
        return null;
    }

    @JsxFunction
    public NativeArray getAll(String name) {
        LinkedList<String> result = new LinkedList<String>();
        for (Map.Entry<String, String> param : this.params_) {
            if (!param.getKey().equals(name)) continue;
            result.add(param.getValue());
        }
        NativeArray jsValues = new NativeArray(result.toArray());
        ScriptRuntime.setBuiltinProtoAndParent(jsValues, URLSearchParams.getWindow(this), TopLevel.Builtins.Array);
        return jsValues;
    }

    @JsxFunction
    public void set(String name, String value) {
        Iterator<Map.Entry<String, String>> iter = this.params_.iterator();
        boolean change = true;
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            if (!entry.getKey().equals(name)) continue;
            if (change) {
                entry.setValue(value);
                change = false;
                continue;
            }
            iter.remove();
        }
        if (change) {
            this.append(name, value);
        }
    }

    @JsxFunction
    public boolean has(String name) {
        for (Map.Entry<String, String> param : this.params_) {
            if (!param.getKey().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        StringBuilder paramStr = new StringBuilder();
        String delim = "";
        for (Map.Entry<String, String> param : this.params_) {
            paramStr.append(delim);
            delim = "&";
            paramStr.append(param.getKey());
            paramStr.append("=");
            String value = param.getValue();
            if (value == null) continue;
            paramStr.append(param.getValue());
        }
        return paramStr.toString();
    }
}

