/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlMap;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlArea
extends HtmlElement {
    private static final Log LOG = LogFactory.getLog(HtmlArea.class);
    public static final String TAG_NAME = "area";

    HtmlArea(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    protected boolean doClickStateUpdate(boolean shiftKey, boolean ctrlKey) throws IOException {
        HtmlPage enclosingPage = (HtmlPage)this.getPage();
        WebClient webClient = enclosingPage.getWebClient();
        String href = this.getHrefAttribute().trim();
        if (!href.isEmpty()) {
            URL url;
            HtmlPage page = (HtmlPage)this.getPage();
            if (StringUtils.startsWithIgnoreCase(href, "javascript:")) {
                page.executeJavaScript(href, "javascript url", this.getStartLineNumber());
                return false;
            }
            try {
                url = enclosingPage.getFullyQualifiedUrl(this.getHrefAttribute());
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Not a valid url: " + this.getHrefAttribute());
            }
            WebRequest request = new WebRequest(url);
            request.setAdditionalHeader("Referer", page.getUrl().toExternalForm());
            WebWindow webWindow = enclosingPage.getEnclosingWindow();
            webClient.getPage(webWindow, enclosingPage.getResolvedTarget(this.getTargetAttribute()), request);
        }
        return false;
    }

    public final String getShapeAttribute() {
        return this.getAttribute("shape");
    }

    public final String getCoordsAttribute() {
        return this.getAttribute("coords");
    }

    public final String getHrefAttribute() {
        return this.getAttribute("href");
    }

    public final String getNoHrefAttribute() {
        return this.getAttribute("nohref");
    }

    public final String getAltAttribute() {
        return this.getAttribute("alt");
    }

    public final String getTabIndexAttribute() {
        return this.getAttribute("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttribute("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttribute("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttribute("onblur");
    }

    public final String getTargetAttribute() {
        return this.getAttribute("target");
    }

    boolean containsPoint(int x, int y) {
        String shape = StringUtils.defaultIfEmpty(this.getShapeAttribute(), "rect").toLowerCase(Locale.ROOT);
        if ("default".equals(shape) && this.getCoordsAttribute() != null) {
            return true;
        }
        if ("rect".equals(shape) && this.getCoordsAttribute() != null) {
            Rectangle2D rectangle = this.parseRect();
            return rectangle.contains(x, y);
        }
        if ("circle".equals(shape) && this.getCoordsAttribute() != null) {
            Ellipse2D ellipse = this.parseCircle();
            return ellipse.contains(x, y);
        }
        if ("poly".equals(shape) && this.getCoordsAttribute() != null) {
            GeneralPath path = this.parsePoly();
            return path.contains(x, y);
        }
        return false;
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        if (this.hasFeature(BrowserVersionFeatures.CSS_DISPLAY_BLOCK)) {
            return HtmlElement.DisplayStyle.NONE;
        }
        return HtmlElement.DisplayStyle.INLINE;
    }

    @Override
    public boolean isDisplayed() {
        DomNode parent = this.getParentNode();
        if (null != parent && parent instanceof HtmlMap && parent.isDisplayed()) {
            return !this.isEmpty();
        }
        return false;
    }

    private Rectangle2D parseRect() {
        String[] coords = StringUtils.split(this.getCoordsAttribute(), ", ");
        double leftX = 0.0;
        double topY = 0.0;
        double rightX = 0.0;
        double bottomY = 0.0;
        try {
            if (coords.length > 0) {
                leftX = Double.parseDouble(coords[0].trim());
            }
            if (coords.length > 1) {
                topY = Double.parseDouble(coords[1].trim());
            }
            if (coords.length > 2) {
                rightX = Double.parseDouble(coords[2].trim());
            }
            if (coords.length > 3) {
                bottomY = Double.parseDouble(coords[3].trim());
            }
        }
        catch (NumberFormatException e) {
            LOG.warn("Invalid rect coords '" + coords + "'", e);
        }
        Rectangle2D.Double rectangle = new Rectangle2D.Double(leftX, topY, rightX - leftX, bottomY - topY);
        return rectangle;
    }

    private Ellipse2D parseCircle() {
        int radius;
        String[] coords = StringUtils.split(this.getCoordsAttribute(), ", ");
        String radiusString = coords[2].trim();
        try {
            radius = Integer.parseInt(radiusString);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException("Circle radius of " + radiusString + " is not yet implemented.");
        }
        double centerX = Double.parseDouble(coords[0].trim());
        double centerY = Double.parseDouble(coords[1].trim());
        Ellipse2D.Double ellipse = new Ellipse2D.Double(centerX - (double)radius / 2.0, centerY - (double)radius / 2.0, radius, radius);
        return ellipse;
    }

    private GeneralPath parsePoly() {
        String[] coords = StringUtils.split(this.getCoordsAttribute(), ", ");
        GeneralPath path = new GeneralPath();
        try {
            int i = 0;
            while (i + 1 < coords.length) {
                if (i == 0) {
                    path.moveTo(Float.parseFloat(coords[i]), Float.parseFloat(coords[i + 1]));
                } else {
                    path.lineTo(Float.parseFloat(coords[i]), Float.parseFloat(coords[i + 1]));
                }
                i += 2;
            }
        }
        catch (NumberFormatException e) {
            LOG.warn("Invalid poly coords '" + coords + "'", e);
        }
        path.closePath();
        return path;
    }

    private boolean isEmpty() {
        String shape = StringUtils.defaultIfEmpty(this.getShapeAttribute(), "rect").toLowerCase(Locale.ROOT);
        if ("default".equals(shape) && this.getCoordsAttribute() != null) {
            return false;
        }
        if ("rect".equals(shape) && this.getCoordsAttribute() != null) {
            Rectangle2D rectangle = this.parseRect();
            return rectangle.isEmpty();
        }
        if ("circle".equals(shape) && this.getCoordsAttribute() != null) {
            Ellipse2D ellipse = this.parseCircle();
            return ellipse.isEmpty();
        }
        if ("poly".equals(shape) && this.getCoordsAttribute() != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean handles(Event event) {
        if ("blur".equals(event.getType()) || "focus".equals(event.getType())) {
            return true;
        }
        return super.handles(event);
    }
}

