/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.PluginConfiguration;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.javascript.configuration.AbstractJavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserFeature;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.io.FilenameUtils;

public final class BrowserVersion
implements Serializable {
    private static final String NETSCAPE = "Netscape";
    private static final String LANGUAGE_ENGLISH_US = "en-US";
    private static final String TIMEZONE_NEW_YORK = "America/New_York";
    private static final String CPU_CLASS_X86 = "x86";
    private static final String PLATFORM_WIN32 = "Win32";
    private static final String PLATFORM_WIN64 = "Win64";
    public static final BrowserVersion FIREFOX_45 = new BrowserVersion(45, "FF45");
    public static final BrowserVersion FIREFOX_52 = new BrowserVersion(52, "FF52");
    public static final BrowserVersion INTERNET_EXPLORER = new BrowserVersion(11, "IE");
    public static final BrowserVersion CHROME = new BrowserVersion(60, "Chrome");
    public static final BrowserVersion EDGE = new BrowserVersion(14, "Edge");
    public static final BrowserVersion BEST_SUPPORTED;
    private static BrowserVersion DefaultBrowserVersion_;
    private final int browserVersionNumeric_;
    private final String nickname_;
    private String applicationCodeName_ = "Mozilla";
    private String applicationMinorVersion_ = "0";
    private String applicationName_;
    private String applicationVersion_;
    private String buildId_;
    private String productSub_;
    private String vendor_ = "";
    private String browserLanguage_ = "en-US";
    private String cpuClass_ = "x86";
    private boolean onLine_ = true;
    private String platform_ = "Win64";
    private String systemLanguage_ = "en-US";
    private TimeZone systemTimezone_ = TimeZone.getTimeZone("America/New_York");
    private String userAgent_;
    private String userLanguage_ = "en-US";
    private final Set<PluginConfiguration> plugins_;
    private final Set<BrowserVersionFeatures> features_;
    private String htmlAcceptHeader_;
    private String imgAcceptHeader_;
    private String cssAcceptHeader_;
    private String scriptAcceptHeader_;
    private String xmlHttpRequestAcceptHeader_;
    private String[] headerNamesOrdered_;
    private int[] fontHeights_;
    private final Map<String, String> uploadMimeTypes_;

    private BrowserVersion(int browserVersionNumeric, String nickname) {
        this.browserVersionNumeric_ = browserVersionNumeric;
        this.nickname_ = nickname;
        this.applicationName_ = NETSCAPE;
        this.htmlAcceptHeader_ = "*/*";
        this.imgAcceptHeader_ = "*/*";
        this.cssAcceptHeader_ = "*/*";
        this.scriptAcceptHeader_ = "*/*";
        this.xmlHttpRequestAcceptHeader_ = "*/*";
        this.plugins_ = new HashSet<PluginConfiguration>();
        this.features_ = EnumSet.noneOf(BrowserVersionFeatures.class);
        this.uploadMimeTypes_ = new HashMap<String, String>();
        this.initFeatures();
    }

    private void initFeatures() {
        SupportedBrowser expectedBrowser = this.isChrome() ? SupportedBrowser.CHROME : (this.isFirefox52() ? SupportedBrowser.FF52 : (this.isFirefox() ? SupportedBrowser.FF45 : (this.isIE() ? SupportedBrowser.IE : SupportedBrowser.EDGE)));
        for (BrowserVersionFeatures features : BrowserVersionFeatures.values()) {
            try {
                Field field = BrowserVersionFeatures.class.getField(features.name());
                BrowserFeature browserFeature = field.getAnnotation(BrowserFeature.class);
                if (browserFeature == null) continue;
                for (SupportedBrowser browser : browserFeature.value()) {
                    if (!AbstractJavaScriptConfiguration.isCompatible(expectedBrowser, browser)) continue;
                    this.features_.add(features);
                }
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static BrowserVersion getDefault() {
        return DefaultBrowserVersion_;
    }

    public static void setDefault(BrowserVersion newBrowserVersion) {
        WebAssert.notNull("newBrowserVersion", newBrowserVersion);
        DefaultBrowserVersion_ = newBrowserVersion;
    }

    public boolean isIE() {
        return this.getNickname().startsWith("IE");
    }

    public boolean isChrome() {
        return this.getNickname().startsWith("Chrome");
    }

    public boolean isEdge() {
        return this.getNickname().startsWith("Edge");
    }

    public boolean isFirefox() {
        return this.getNickname().startsWith("FF");
    }

    public boolean isFirefox52() {
        return this.isFirefox() && this.getBrowserVersionNumeric() == 52;
    }

    public String getNickname() {
        return this.nickname_;
    }

    public int getBrowserVersionNumeric() {
        return this.browserVersionNumeric_;
    }

    public String getApplicationCodeName() {
        return this.applicationCodeName_;
    }

    public String getApplicationMinorVersion() {
        return this.applicationMinorVersion_;
    }

    public String getApplicationName() {
        return this.applicationName_;
    }

    public String getApplicationVersion() {
        return this.applicationVersion_;
    }

    public String getVendor() {
        return this.vendor_;
    }

    public String getBrowserLanguage() {
        return this.browserLanguage_;
    }

    public String getCpuClass() {
        return this.cpuClass_;
    }

    public boolean isOnLine() {
        return this.onLine_;
    }

    public String getPlatform() {
        return this.platform_;
    }

    public String getSystemLanguage() {
        return this.systemLanguage_;
    }

    public TimeZone getSystemTimezone() {
        return this.systemTimezone_;
    }

    public String getUserAgent() {
        return this.userAgent_;
    }

    public String getUserLanguage() {
        return this.userLanguage_;
    }

    public String getHtmlAcceptHeader() {
        return this.htmlAcceptHeader_;
    }

    public String getScriptAcceptHeader() {
        return this.scriptAcceptHeader_;
    }

    public String getXmlHttpRequestAcceptHeader() {
        return this.xmlHttpRequestAcceptHeader_;
    }

    public String getImgAcceptHeader() {
        return this.imgAcceptHeader_;
    }

    public String getCssAcceptHeader() {
        return this.cssAcceptHeader_;
    }

    public Set<PluginConfiguration> getPlugins() {
        return this.plugins_;
    }

    public boolean hasFeature(BrowserVersionFeatures property) {
        return this.features_.contains((Object)property);
    }

    public String getBuildId() {
        return this.buildId_;
    }

    public String getProductSub() {
        return this.productSub_;
    }

    public String[] getHeaderNamesOrdered() {
        return this.headerNamesOrdered_;
    }

    public void registerUploadMimeType(String fileExtension, String mimeType) {
        if (fileExtension != null) {
            this.uploadMimeTypes_.put(fileExtension.toLowerCase(Locale.ROOT), mimeType);
        }
    }

    public String getUploadMimeType(File file) {
        if (file == null) {
            return "";
        }
        String fileExtension = FilenameUtils.getExtension(file.getName());
        String mimeType = this.uploadMimeTypes_.get(fileExtension.toLowerCase(Locale.ROOT));
        if (mimeType != null) {
            return mimeType;
        }
        return "";
    }

    public int getFontHeight(String fontSize) {
        if (this.fontHeights_ == null) {
            return 18;
        }
        int fontSizeInt = Integer.parseInt(fontSize.substring(0, fontSize.length() - 2));
        if (fontSizeInt < this.fontHeights_.length) {
            return this.fontHeights_[fontSizeInt];
        }
        return (int)((double)fontSizeInt * 1.2);
    }

    public int getPixesPerChar() {
        return 10;
    }

    public String toString() {
        return this.nickname_;
    }

    static /* synthetic */ String[] access$802(BrowserVersion x0, String[] x1) {
        x0.headerNamesOrdered_ = x1;
        return x1;
    }

    static /* synthetic */ int[] access$902(BrowserVersion x0, int[] x1) {
        x0.fontHeights_ = x1;
        return x1;
    }

    static {
        DefaultBrowserVersion_ = BEST_SUPPORTED = CHROME;
        BrowserVersion.FIREFOX_45.applicationVersion_ = "5.0 (Windows)";
        BrowserVersion.FIREFOX_45.userAgent_ = "Mozilla/5.0 (Windows NT 6.1; rv:45.0) Gecko/20100101 Firefox/45.0";
        BrowserVersion.FIREFOX_45.platform_ = PLATFORM_WIN32;
        BrowserVersion.FIREFOX_45.buildId_ = "20170411115307";
        BrowserVersion.FIREFOX_45.productSub_ = "20100101";
        BrowserVersion.FIREFOX_45.headerNamesOrdered_ = new String[]{"Host", "User-Agent", "Accept", "Accept-Language", "Accept-Encoding", "Referer", "Cookie", "Connection"};
        BrowserVersion.FIREFOX_45.htmlAcceptHeader_ = "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
        BrowserVersion.FIREFOX_45.xmlHttpRequestAcceptHeader_ = "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
        BrowserVersion.FIREFOX_45.imgAcceptHeader_ = "image/png,image/*;q=0.8,*/*;q=0.5";
        BrowserVersion.FIREFOX_45.cssAcceptHeader_ = "text/css,*/*;q=0.1";
        BrowserVersion.FIREFOX_45.fontHeights_ = new int[]{0, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 30, 31, 32, 33, 34, 35, 36, 37, 38, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 52, 53, 53, 55, 57, 58, 59, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 72, 73, 74, 75, 76, 77, 78, 79, 80, 82, 84, 85, 86, 87, 88, 89, 90, 91, 93, 94, 95, 96, 96, 98, 99, 100, 101, 103, 104, 105, 106, 106, 108, 109, 111, 112, 113, 115, 116, 117, 118, 119, 120, 121, 122, 123, 125, 126, 127, 128, 129, 130, 131, 132, 133, 135, 136, 138, 139, 139, 141, 142, 143, 144, 146, 147, 148, 149};
        BrowserVersion.FIREFOX_52.applicationVersion_ = "5.0 (Windows)";
        BrowserVersion.FIREFOX_52.userAgent_ = "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:52.0) Gecko/20100101 Firefox/52.0";
        BrowserVersion.FIREFOX_52.buildId_ = "20171206101620";
        BrowserVersion.FIREFOX_52.productSub_ = "20100101";
        BrowserVersion.FIREFOX_52.headerNamesOrdered_ = new String[]{"Host", "User-Agent", "Accept", "Accept-Language", "Accept-Encoding", "Referer", "Cookie", "Connection", "Upgrade-Insecure-Requests"};
        BrowserVersion.FIREFOX_52.htmlAcceptHeader_ = "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
        BrowserVersion.FIREFOX_52.cssAcceptHeader_ = "text/css,*/*;q=0.1";
        BrowserVersion.FIREFOX_52.fontHeights_ = new int[]{0, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 30, 31, 32, 33, 34, 35, 36, 37, 38, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 52, 53, 53, 55, 57, 58, 59, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 72, 73, 74, 75, 76, 77, 78, 79, 80, 82, 84, 85, 86, 87, 88, 89, 90, 91, 93, 94, 95, 96, 96, 98, 99, 100, 101, 103, 104, 105, 106, 106, 108, 109, 111, 112, 113, 115, 116, 117, 118, 119, 120, 121, 122, 123, 125, 126, 127, 128, 129, 130, 131, 132, 133, 135, 136, 138, 139, 139, 141, 142, 143, 144, 146, 147, 148, 149};
        BrowserVersion.INTERNET_EXPLORER.applicationVersion_ = "5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko";
        BrowserVersion.INTERNET_EXPLORER.userAgent_ = "Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko";
        BrowserVersion.INTERNET_EXPLORER.platform_ = PLATFORM_WIN32;
        BrowserVersion.INTERNET_EXPLORER.headerNamesOrdered_ = new String[]{"Accept", "Referer", "Accept-Language", "User-Agent", "Accept-Encoding", "Host", "DNT", "Connection", "Cookie"};
        BrowserVersion.INTERNET_EXPLORER.htmlAcceptHeader_ = "text/html, application/xhtml+xml, */*";
        BrowserVersion.INTERNET_EXPLORER.imgAcceptHeader_ = "image/png, image/svg+xml, image/*;q=0.8, */*;q=0.5";
        BrowserVersion.INTERNET_EXPLORER.cssAcceptHeader_ = "text/css, */*";
        BrowserVersion.INTERNET_EXPLORER.scriptAcceptHeader_ = "application/javascript, */*;q=0.8";
        BrowserVersion.INTERNET_EXPLORER.fontHeights_ = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 20, 21, 22, 23, 24, 25, 26, 28, 29, 30, 31, 32, 33, 35, 36, 37, 38, 39, 40, 41, 43, 44, 45, 46, 47, 48, 49, 51, 52, 53, 54, 55, 56, 58, 59, 60, 61, 62, 63, 64, 66, 67, 68, 69, 70, 71, 72, 74, 75, 76, 77, 78, 79, 80, 82, 83, 84, 85, 86, 87, 89, 90, 91, 92, 93, 94, 95, 97, 98, 99, 100, 101, 102, 103, 105, 106, 107, 108, 109, 110, 112, 113, 114, 115, 116, 117, 118, 120, 121, 122, 123, 124, 125, 126, 128, 129, 130, 131, 132, 133, 135, 136, 137, 138, 139, 140, 141, 143, 144, 145, 146, 147};
        BrowserVersion.EDGE.applicationVersion_ = "5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393";
        BrowserVersion.EDGE.userAgent_ = "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393";
        BrowserVersion.CHROME.applicationVersion_ = "5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.108 Safari/537.36";
        BrowserVersion.CHROME.userAgent_ = "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.108 Safari/537.36";
        BrowserVersion.CHROME.applicationCodeName_ = "Mozilla";
        BrowserVersion.CHROME.vendor_ = "Google Inc.";
        BrowserVersion.CHROME.platform_ = PLATFORM_WIN32;
        BrowserVersion.CHROME.cpuClass_ = null;
        BrowserVersion.CHROME.productSub_ = "20030107";
        BrowserVersion.CHROME.headerNamesOrdered_ = new String[]{"Host", "Connection", "Upgrade-Insecure-Requests", "User-Agent", "Accept", "Referer", "Accept-Encoding", "Accept-Language", "Cookie"};
        BrowserVersion.CHROME.htmlAcceptHeader_ = "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8";
        BrowserVersion.CHROME.imgAcceptHeader_ = "image/webp,image/apng,image/*,*/*;q=0.8";
        BrowserVersion.CHROME.cssAcceptHeader_ = "text/css,*/*;q=0.1";
        BrowserVersion.CHROME.scriptAcceptHeader_ = "*/*";
        BrowserVersion.CHROME.fontHeights_ = new int[]{0, 1, 2, 4, 5, 5, 6, 8, 9, 10, 11, 12, 15, 16, 16, 17, 18, 20, 21, 22, 23, 25, 26, 26, 27, 28, 30, 31, 32, 33, 34, 36, 37, 37, 38, 40, 42, 43, 44, 45, 47, 48, 48, 49, 51, 52, 53, 54, 55, 57, 58, 58, 59, 60, 62, 63, 64, 65, 67, 69, 69, 70, 71, 73, 74, 75, 76, 77, 79, 79, 80, 81, 83, 84, 85, 86, 87, 89, 90, 90, 91, 93, 94, 96, 97, 98, 100, 101, 101, 102, 103, 105, 106, 107, 108, 110, 111, 111, 112, 113, 115, 116, 117, 118, 119, 121, 122, 123, 124, 126, 127, 128, 129, 130, 132, 132, 133, 134, 136, 137, 138, 139, 140, 142, 142, 143, 144, 145, 147};
        CHROME.registerUploadMimeType("html", "text/html");
        CHROME.registerUploadMimeType("htm", "text/html");
        CHROME.registerUploadMimeType("css", "text/css");
        CHROME.registerUploadMimeType("xml", "text/xml");
        CHROME.registerUploadMimeType("gif", "image/gif");
        CHROME.registerUploadMimeType("jpeg", "image/jpeg");
        CHROME.registerUploadMimeType("jpg", "image/jpeg");
        CHROME.registerUploadMimeType("webp", "image/webp");
        CHROME.registerUploadMimeType("mp4", "video/mp4");
        CHROME.registerUploadMimeType("m4v", "video/mp4");
        CHROME.registerUploadMimeType("m4a", "audio/x-m4a");
        CHROME.registerUploadMimeType("mp3", "audio/mp3");
        CHROME.registerUploadMimeType("ogv", "video/ogg");
        CHROME.registerUploadMimeType("ogm", "video/ogg");
        CHROME.registerUploadMimeType("ogg", "audio/ogg");
        CHROME.registerUploadMimeType("oga", "audio/ogg");
        CHROME.registerUploadMimeType("opus", "audio/ogg");
        CHROME.registerUploadMimeType("webm", "video/webm");
        CHROME.registerUploadMimeType("wav", "audio/wav");
        CHROME.registerUploadMimeType("flac", "audio/flac");
        CHROME.registerUploadMimeType("xhtml", "application/xhtml+xml");
        CHROME.registerUploadMimeType("xht", "application/xhtml+xml");
        CHROME.registerUploadMimeType("xhtm", "application/xhtml+xml");
        CHROME.registerUploadMimeType("txt", "text/plain");
        CHROME.registerUploadMimeType("text", "text/plain");
        FIREFOX_45.registerUploadMimeType("html", "text/html");
        FIREFOX_45.registerUploadMimeType("htm", "text/html");
        FIREFOX_45.registerUploadMimeType("css", "text/css");
        FIREFOX_45.registerUploadMimeType("xml", "text/xml");
        FIREFOX_45.registerUploadMimeType("gif", "image/gif");
        FIREFOX_45.registerUploadMimeType("jpeg", "image/jpeg");
        FIREFOX_45.registerUploadMimeType("jpg", "image/jpeg");
        FIREFOX_45.registerUploadMimeType("mp4", "video/mp4");
        FIREFOX_45.registerUploadMimeType("m4v", "video/mp4");
        FIREFOX_45.registerUploadMimeType("m4a", "audio/mp4");
        FIREFOX_45.registerUploadMimeType("mp3", "audio/mpeg");
        FIREFOX_45.registerUploadMimeType("ogv", "video/ogg");
        FIREFOX_45.registerUploadMimeType("ogm", "video/x-ogm");
        FIREFOX_45.registerUploadMimeType("ogg", "video/ogg");
        FIREFOX_45.registerUploadMimeType("oga", "audio/ogg");
        FIREFOX_45.registerUploadMimeType("opus", "audio/ogg");
        FIREFOX_45.registerUploadMimeType("webm", "video/webm");
        FIREFOX_45.registerUploadMimeType("wav", "audio/wav");
        FIREFOX_45.registerUploadMimeType("flac", "audio/x-flac");
        FIREFOX_45.registerUploadMimeType("xhtml", "application/xhtml+xml");
        FIREFOX_45.registerUploadMimeType("xht", "application/xhtml+xml");
        FIREFOX_45.registerUploadMimeType("txt", "text/plain");
        FIREFOX_45.registerUploadMimeType("text", "text/plain");
        FIREFOX_52.registerUploadMimeType("html", "text/html");
        FIREFOX_52.registerUploadMimeType("htm", "text/html");
        FIREFOX_52.registerUploadMimeType("css", "text/css");
        FIREFOX_52.registerUploadMimeType("xml", "text/xml");
        FIREFOX_52.registerUploadMimeType("gif", "image/gif");
        FIREFOX_52.registerUploadMimeType("jpeg", "image/jpeg");
        FIREFOX_52.registerUploadMimeType("jpg", "image/jpeg");
        FIREFOX_52.registerUploadMimeType("mp4", "video/mp4");
        FIREFOX_52.registerUploadMimeType("m4v", "video/mp4");
        FIREFOX_52.registerUploadMimeType("m4a", "audio/mp4");
        FIREFOX_52.registerUploadMimeType("mp3", "audio/mpeg");
        FIREFOX_52.registerUploadMimeType("ogv", "video/ogg");
        FIREFOX_52.registerUploadMimeType("ogm", "video/x-ogm");
        FIREFOX_52.registerUploadMimeType("ogg", "video/ogg");
        FIREFOX_52.registerUploadMimeType("oga", "audio/ogg");
        FIREFOX_52.registerUploadMimeType("opus", "audio/ogg");
        FIREFOX_52.registerUploadMimeType("webm", "video/webm");
        FIREFOX_52.registerUploadMimeType("wav", "audio/wav");
        FIREFOX_52.registerUploadMimeType("xhtml", "application/xhtml+xml");
        FIREFOX_52.registerUploadMimeType("xht", "application/xhtml+xml");
        FIREFOX_52.registerUploadMimeType("txt", "text/plain");
        FIREFOX_52.registerUploadMimeType("text", "text/plain");
        INTERNET_EXPLORER.registerUploadMimeType("html", "text/html");
        INTERNET_EXPLORER.registerUploadMimeType("htm", "text/html");
        INTERNET_EXPLORER.registerUploadMimeType("css", "text/css");
        INTERNET_EXPLORER.registerUploadMimeType("xml", "text/xml");
        INTERNET_EXPLORER.registerUploadMimeType("gif", "image/gif");
        INTERNET_EXPLORER.registerUploadMimeType("jpeg", "image/jpeg");
        INTERNET_EXPLORER.registerUploadMimeType("jpg", "image/jpeg");
        INTERNET_EXPLORER.registerUploadMimeType("mp4", "video/mp4");
        INTERNET_EXPLORER.registerUploadMimeType("m4v", "video/mp4");
        INTERNET_EXPLORER.registerUploadMimeType("m4a", "audio/mp4");
        INTERNET_EXPLORER.registerUploadMimeType("mp3", "audio/mpeg");
        INTERNET_EXPLORER.registerUploadMimeType("ogm", "video/x-ogm");
        INTERNET_EXPLORER.registerUploadMimeType("ogg", "application/ogg");
        INTERNET_EXPLORER.registerUploadMimeType("wav", "audio/wav");
        INTERNET_EXPLORER.registerUploadMimeType("xhtml", "application/xhtml+xml");
        INTERNET_EXPLORER.registerUploadMimeType("xht", "application/xhtml+xml");
        INTERNET_EXPLORER.registerUploadMimeType("txt", "text/plain");
        EDGE.registerUploadMimeType("html", "text/html");
        EDGE.registerUploadMimeType("htm", "text/html");
        EDGE.registerUploadMimeType("css", "text/css");
        EDGE.registerUploadMimeType("xml", "text/xml");
        EDGE.registerUploadMimeType("gif", "image/gif");
        EDGE.registerUploadMimeType("jpeg", "image/jpeg");
        EDGE.registerUploadMimeType("jpg", "image/jpeg");
        EDGE.registerUploadMimeType("mp4", "video/mp4");
        EDGE.registerUploadMimeType("m4v", "video/mp4");
        EDGE.registerUploadMimeType("m4a", "audio/mp4");
        EDGE.registerUploadMimeType("mp3", "audio/mpeg");
        EDGE.registerUploadMimeType("ogm", "video/x-ogm");
        EDGE.registerUploadMimeType("ogg", "application/ogg");
        EDGE.registerUploadMimeType("wav", "audio/wav");
        EDGE.registerUploadMimeType("xhtml", "application/xhtml+xml");
        EDGE.registerUploadMimeType("xht", "application/xhtml+xml");
        EDGE.registerUploadMimeType("txt", "text/plain");
        PluginConfiguration flash = new PluginConfiguration("Shockwave Flash", "Shockwave Flash 28.0 r0", "28.0.0.126", "NPSWF32_28_0_0_126.dll");
        flash.getMimeTypes().add(new PluginConfiguration.MimeType("application/x-shockwave-flash", "Shockwave Flash", "swf"));
        BrowserVersion.FIREFOX_45.plugins_.add(flash);
        flash = new PluginConfiguration("Shockwave Flash", "Shockwave Flash 28.0 r0", "28.0.0.126", "NPSWF64_28_0_0_126.dll");
        flash.getMimeTypes().add(new PluginConfiguration.MimeType("application/x-shockwave-flash", "Shockwave Flash", "swf"));
        BrowserVersion.FIREFOX_52.plugins_.add(flash);
        flash = new PluginConfiguration("Shockwave Flash", "Shockwave Flash 28.0 r0", "28.0.0.126", "Flash32_28_0_0_126.ocx");
        flash.getMimeTypes().add(new PluginConfiguration.MimeType("application/x-shockwave-flash", "Shockwave Flash", "swf"));
        BrowserVersion.INTERNET_EXPLORER.plugins_.add(flash);
        flash = new PluginConfiguration("Shockwave Flash", "Shockwave Flash 18.0 r0", "18.0.0.232", "Flash.ocx");
        flash.getMimeTypes().add(new PluginConfiguration.MimeType("application/x-shockwave-flash", "Shockwave Flash", "swf"));
        BrowserVersion.EDGE.plugins_.add(flash);
    }

    public static class BrowserVersionBuilder {
        private final BrowserVersion workPiece_;

        public BrowserVersionBuilder(BrowserVersion version) {
            this.workPiece_ = new BrowserVersion(version.getBrowserVersionNumeric(), version.getNickname());
            this.setApplicationVersion(version.getApplicationVersion()).setUserAgent(version.getUserAgent()).setApplicationName(version.getApplicationName()).setApplicationCodeName(version.getApplicationCodeName()).setApplicationMinorVersion(version.getApplicationMinorVersion()).setVendor(version.getVendor()).setBrowserLanguage(version.getBrowserLanguage()).setCpuClass(version.getCpuClass()).setOnLine(version.isOnLine()).setPlatform(version.getPlatform()).setSystemLanguage(version.getSystemLanguage()).setSystemTimezone(version.getSystemTimezone()).setUserLanguage(version.getUserLanguage());
            this.workPiece_.buildId_ = version.getBuildId();
            this.workPiece_.productSub_ = version.getProductSub();
            this.workPiece_.htmlAcceptHeader_ = version.getHtmlAcceptHeader();
            this.workPiece_.imgAcceptHeader_ = version.getImgAcceptHeader();
            this.workPiece_.cssAcceptHeader_ = version.getCssAcceptHeader();
            this.workPiece_.scriptAcceptHeader_ = version.getScriptAcceptHeader();
            this.workPiece_.xmlHttpRequestAcceptHeader_ = version.getXmlHttpRequestAcceptHeader();
            BrowserVersion.access$802(this.workPiece_, version.getHeaderNamesOrdered());
            BrowserVersion.access$902(this.workPiece_, version.fontHeights_);
            for (PluginConfiguration pluginConf : version.getPlugins()) {
                this.workPiece_.plugins_.add(pluginConf.clone());
            }
            this.workPiece_.features_.addAll(version.features_);
            this.workPiece_.uploadMimeTypes_.putAll(version.uploadMimeTypes_);
        }

        public BrowserVersion build() {
            return this.workPiece_;
        }

        public BrowserVersionBuilder setApplicationMinorVersion(String applicationMinorVersion) {
            this.workPiece_.applicationMinorVersion_ = applicationMinorVersion;
            return this;
        }

        public BrowserVersionBuilder setApplicationName(String applicationName) {
            this.workPiece_.applicationName_ = applicationName;
            return this;
        }

        public BrowserVersionBuilder setApplicationVersion(String applicationVersion) {
            this.workPiece_.applicationVersion_ = applicationVersion;
            return this;
        }

        public BrowserVersionBuilder setVendor(String vendor) {
            this.workPiece_.vendor_ = vendor;
            return this;
        }

        public BrowserVersionBuilder setApplicationCodeName(String applicationCodeName) {
            this.workPiece_.applicationCodeName_ = applicationCodeName;
            return this;
        }

        public BrowserVersionBuilder setBrowserLanguage(String browserLanguage) {
            this.workPiece_.browserLanguage_ = browserLanguage;
            return this;
        }

        public BrowserVersionBuilder setCpuClass(String cpuClass) {
            this.workPiece_.cpuClass_ = cpuClass;
            return this;
        }

        public BrowserVersionBuilder setOnLine(boolean onLine) {
            this.workPiece_.onLine_ = onLine;
            return this;
        }

        public BrowserVersionBuilder setPlatform(String platform) {
            this.workPiece_.platform_ = platform;
            return this;
        }

        public BrowserVersionBuilder setSystemLanguage(String systemLanguage) {
            this.workPiece_.systemLanguage_ = systemLanguage;
            return this;
        }

        public BrowserVersionBuilder setSystemTimezone(TimeZone systemTimezone) {
            this.workPiece_.systemTimezone_ = systemTimezone;
            return this;
        }

        public BrowserVersionBuilder setUserAgent(String userAgent) {
            this.workPiece_.userAgent_ = userAgent;
            return this;
        }

        public BrowserVersionBuilder setUserLanguage(String userLanguage) {
            this.workPiece_.userLanguage_ = userLanguage;
            return this;
        }

        public BrowserVersionBuilder setHtmlAcceptHeader(String htmlAcceptHeader) {
            this.workPiece_.htmlAcceptHeader_ = htmlAcceptHeader;
            return this;
        }

        public BrowserVersionBuilder setImgAcceptHeader(String imgAcceptHeader) {
            this.workPiece_.imgAcceptHeader_ = imgAcceptHeader;
            return this;
        }

        public BrowserVersionBuilder setCssAcceptHeader(String cssAcceptHeader) {
            this.workPiece_.cssAcceptHeader_ = cssAcceptHeader;
            return this;
        }

        public BrowserVersionBuilder setScriptAcceptHeader(String scriptAcceptHeader) {
            this.workPiece_.scriptAcceptHeader_ = scriptAcceptHeader;
            return this;
        }

        public BrowserVersionBuilder setXmlHttpRequestAcceptHeader(String xmlHttpRequestAcceptHeader) {
            this.workPiece_.xmlHttpRequestAcceptHeader_ = xmlHttpRequestAcceptHeader;
            return this;
        }
    }
}

