/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.token;

import com.google.common.collect.Maps;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EscapingWriter
extends FilterWriter {
    private static final Map<Character, char[]> REPLACE;
    private final char[] escapedBuffer = new char[256];

    public EscapingWriter(Writer out) {
        super(out);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        int pos = 0;
        for (int i = off; i < len; ++i) {
            pos = REPLACE.containsKey(Character.valueOf(cbuf[i])) ? this.writeToBuffer(pos, REPLACE.get(Character.valueOf(cbuf[i]))) : this.writeToBuffer(pos, cbuf[i]);
        }
        this.out.write(this.escapedBuffer, 0, pos);
    }

    private int writeToBuffer(int pos, char c) throws IOException {
        if (pos + 1 > this.escapedBuffer.length) {
            this.out.write(this.escapedBuffer, 0, pos);
            pos = 0;
        }
        this.escapedBuffer[pos++] = c;
        return pos;
    }

    private int writeToBuffer(int pos, char[] characters) throws IOException {
        if (pos + characters.length > this.escapedBuffer.length) {
            this.out.write(this.escapedBuffer, 0, pos);
            pos = 0;
        }
        System.arraycopy(characters, 0, this.escapedBuffer, 0, pos);
        return pos += characters.length;
    }

    public void write(int c) throws IOException {
        Character chr = Character.valueOf((char)c);
        if (REPLACE.containsKey(chr)) {
            this.out.write(REPLACE.get(chr));
        } else {
            this.out.write(c);
        }
    }

    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    static {
        HashMap<Character, char[]> replace = Maps.newHashMap();
        replace.put(Character.valueOf('\\'), new char[]{'\\', '\\'});
        replace.put(Character.valueOf('\n'), new char[]{'\\', 'n'});
        replace.put(Character.valueOf('\r'), new char[]{'\\', 'r'});
        replace.put(Character.valueOf('\f'), new char[]{'\\', 'f'});
        replace.put(Character.valueOf('\''), new char[]{'\\', '\''});
        replace.put(Character.valueOf('\"'), new char[]{'\\', '\"'});
        REPLACE = Collections.unmodifiableMap(replace);
    }
}

