/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.servlet;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.jstestdriver.protocol.BrowserLog;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserLoggingServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(BrowserLoggingServlet.class);
    private final Gson gson = new Gson();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            Collection logs = (Collection)this.gson.fromJson(req.getParameter("logs"), new TypeToken<Collection<BrowserLog>>(){}.getType());
            block12: for (BrowserLog log : logs) {
                Logger logger = LoggerFactory.getLogger(log.getSource());
                switch (log.getLevel()) {
                    case 1: {
                        logger.trace(log.getMessage());
                        continue block12;
                    }
                    case 2: {
                        logger.debug(log.getMessage());
                        continue block12;
                    }
                    case 3: {
                        logger.info(log.getMessage());
                        continue block12;
                    }
                    case 4: {
                        logger.warn(log.getMessage());
                        continue block12;
                    }
                    case 5: {
                        logger.error(log.getMessage());
                        continue block12;
                    }
                }
                throw new ServletException("Unknown logging level:" + log.getLevel());
            }
            resp.setStatus(200);
        }
        catch (RuntimeException e) {
            resp.setStatus(500);
            logger.error("Error during BrowserLog write.", e);
        }
        finally {
            resp.getOutputStream().flush();
        }
    }
}

