/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.output;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.TestResult;
import com.google.jstestdriver.output.TestResultHolder;
import com.google.jstestdriver.output.TestXmlSerializer;
import com.google.jstestdriver.output.XmlPrinter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlPrinterImpl
implements XmlPrinter {
    private final Logger logger = LoggerFactory.getLogger(XmlPrinterImpl.class);
    private final TestResultHolder resultHolder;
    private final String xmlOutputDir;
    private final String fileNameFormat = "TEST-%s.xml";

    @Inject
    public XmlPrinterImpl(TestResultHolder resultHolder, @Named(value="testOutput") String xmlOutputDir) {
        this.resultHolder = resultHolder;
        this.xmlOutputDir = xmlOutputDir;
    }

    @Override
    public void writeXmlReportFiles() {
        Map<BrowserInfo, String> browserNames = XmlPrinterImpl.createUniqueBrowserNames(this.resultHolder.getResults().keySet());
        for (BrowserInfo browser : this.resultHolder.getResults().keySet()) {
            Multimap<String, TestResult> testCaseRollup = this.newMultiMap();
            for (TestResult testResult : this.resultHolder.getResults().get(browser)) {
                testCaseRollup.put(testResult.getTestCaseName(), testResult);
            }
            for (String testCaseName : testCaseRollup.keySet()) {
                String suiteName = this.formatSuiteName(browserNames.get(browser), testCaseName);
                File xmlOutputFile = new File(this.xmlOutputDir, this.formatFileName(suiteName));
                try {
                    xmlOutputFile.createNewFile();
                    TestXmlSerializer serializer = new TestXmlSerializer(new FileWriter(xmlOutputFile));
                    serializer.writeTestCase(suiteName, testCaseRollup.get(testCaseName));
                }
                catch (IOException e) {
                    this.logger.error("Could not create file: {}", (Object)xmlOutputFile.getAbsolutePath(), (Object)e);
                }
            }
        }
    }

    public static Map<BrowserInfo, String> createUniqueBrowserNames(Set<BrowserInfo> browserInfos) {
        HashMap<BrowserInfo, String> result = Maps.newHashMap();
        for (BrowserInfo browserInfo : browserInfos) {
            if (result.containsValue(browserInfo.toString())) {
                result.put(browserInfo, browserInfo.toUniqueString());
                continue;
            }
            result.put(browserInfo, browserInfo.toString());
        }
        return result;
    }

    private String formatFileName(String suiteName) {
        return String.format("TEST-%s.xml", suiteName);
    }

    private String formatSuiteName(String browser, String testCaseName) {
        return String.format("%s.%s", browser.replaceAll("\\s", "_").replaceAll("\\.", ""), testCaseName);
    }

    private Multimap<String, TestResult> newMultiMap() {
        return Multimaps.newMultimap(Maps.newHashMap(), new Supplier<Collection<TestResult>>(){

            @Override
            public Collection<TestResult> get() {
                return Lists.newLinkedList();
            }
        });
    }
}

