/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.output;

import com.google.gson.Gson;
import com.google.jstestdriver.JsException;
import com.google.jstestdriver.TestResult;
import java.io.Writer;
import java.util.Collection;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestXmlSerializer {
    private final Gson gson = new Gson();
    private final TransformerHandler transformerHandler;
    private final Writer fileWriter;

    public TestXmlSerializer(Writer fileWriter) {
        try {
            this.transformerHandler = ((SAXTransformerFactory)SAXTransformerFactory.newInstance()).newTransformerHandler();
            Transformer transformer = this.transformerHandler.getTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            this.transformerHandler.setResult(new StreamResult(fileWriter));
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        this.fileWriter = fileWriter;
    }

    private void startTestSuite(String name, SuiteAggregator totals) {
        try {
            this.transformerHandler.startDocument();
            AttributesImpl atts = new AttributesImpl();
            if (name.trim().length() > 0) {
                atts.addAttribute("", "", "name", "CDATA", name);
                atts.addAttribute("", "", "errors", "CDATA", String.valueOf(totals.error));
                atts.addAttribute("", "", "failures", "CDATA", String.valueOf(totals.failed));
                atts.addAttribute("", "", "tests", "CDATA", String.valueOf(totals.tests));
                atts.addAttribute("", "", "time", "CDATA", String.valueOf(totals.elapsedTime));
            }
            this.transformerHandler.startElement("", "", "testsuite", atts);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private void endTestSuite() {
        try {
            this.transformerHandler.endElement("", "", "testsuite");
            this.transformerHandler.endDocument();
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private void startTestCase(String testCaseName, String testName, float time) {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "classname", "CDATA", testCaseName);
        atts.addAttribute("", "", "name", "CDATA", testName);
        atts.addAttribute("", "", "time", "CDATA", Float.toString(time / 1000.0f));
        try {
            this.transformerHandler.startElement("", "", "testcase", atts);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private void endTestCase() {
        try {
            this.transformerHandler.endElement("", "", "testcase");
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private void addFailure(String stack, String message) {
        try {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "", "type", "CDATA", "failed");
            atts.addAttribute("", "", "message", "CDATA", message);
            this.transformerHandler.startElement("", "", "failure", atts);
            char[] charMsg = stack.toCharArray();
            this.transformerHandler.characters(charMsg, 0, charMsg.length);
            this.transformerHandler.endElement("", "", "failure");
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private void addError(String inner) {
        try {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "", "type", "CDATA", "error");
            this.transformerHandler.startElement("", "", "error", atts);
            char[] charMsg = inner.toCharArray();
            this.transformerHandler.characters(charMsg, 0, charMsg.length);
            this.transformerHandler.endElement("", "", "error");
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private void addOutput(String output) {
        try {
            AttributesImpl atts = new AttributesImpl();
            this.transformerHandler.startElement("", "", "system-out", atts);
            char[] charMsg = output.toCharArray();
            this.transformerHandler.startCDATA();
            this.transformerHandler.characters(charMsg, 0, charMsg.length);
            this.transformerHandler.endCDATA();
            this.transformerHandler.endElement("", "", "system-out");
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeTestCase(String testCaseName, Collection<TestResult> testResults) {
        StringBuilder output = new StringBuilder();
        SuiteAggregator totals = new SuiteAggregator(testResults).aggregate();
        this.startTestSuite(testCaseName, totals);
        for (TestResult testResult : testResults) {
            this.startTestCase(testCaseName, testResult.getTestName(), testResult.getTime());
            if (testResult.getResult() != TestResult.Result.passed) {
                String message;
                try {
                    JsException exception = this.gson.fromJson(testResult.getMessage(), JsException.class);
                    message = exception.getMessage();
                }
                catch (Exception e) {
                    message = testResult.getMessage();
                }
                if (testResult.getResult() == TestResult.Result.failed) {
                    this.addFailure(testResult.getStack(), message);
                } else if (testResult.getResult() == TestResult.Result.error) {
                    this.addError(message);
                }
            }
            output.append(testResult.getLog());
            this.endTestCase();
        }
        if (output.length() > 0) {
            this.addOutput(output.toString());
        }
        this.endTestSuite();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SuiteAggregator {
        int tests = 0;
        int failed = 0;
        int error = 0;
        float elapsedTime = 0.0f;
        private final Collection<TestResult> results;
        private boolean topLevel = false;

        public SuiteAggregator(Collection<TestResult> results) {
            this.results = results;
        }

        public SuiteAggregator aggregate() {
            for (TestResult result : this.results) {
                ++this.tests;
                this.failed += result.getResult() == TestResult.Result.failed ? 1 : 0;
                this.error += result.getResult() == TestResult.Result.error ? 1 : 0;
                this.elapsedTime += result.getTime() / 1000.0f;
            }
            return this;
        }
    }
}

