/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.output;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.jstestdriver.FileResult;
import com.google.jstestdriver.RunData;
import com.google.jstestdriver.TestResult;
import com.google.jstestdriver.output.FileLoadProblem;
import com.google.jstestdriver.output.Problem;
import com.google.jstestdriver.output.TestResultListener;
import com.google.jstestdriver.output.TestResultProblem;
import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

@Singleton
public class DefaultListener
implements TestResultListener {
    static final String NEW_LINE = System.getProperty("line.separator");
    private final PrintStream out;
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private final boolean verbose;
    private final Map<String, RunData> browsersRunData = new ConcurrentHashMap<String, RunData>();
    private final AtomicInteger lineColumn = new AtomicInteger(0);
    private final AtomicInteger totalPasses = new AtomicInteger(0);
    private final AtomicInteger totalFails = new AtomicInteger(0);
    private final AtomicInteger totalErrors = new AtomicInteger(0);
    private int lineLength = 70;

    @Inject
    public DefaultListener(@Named(value="outputStream") PrintStream out, @Named(value="verbose") boolean verbose) {
        this.out = out;
        this.verbose = verbose;
    }

    public void setLineLength(int lineLength) {
        this.lineLength = lineLength;
    }

    public void finish() {
        if (!this.finished.getAndSet(true)) {
            this.printSummary(this.out);
            for (Map.Entry<String, RunData> entry : this.browsersRunData.entrySet()) {
                RunData data = entry.getValue();
                this.printBrowserSummary(this.out, entry.getKey(), data);
                for (Problem problem : data.getProblems()) {
                    problem.print(this.out, this.verbose);
                }
            }
        }
    }

    private void printSummary(PrintStream out) {
        if (!this.verbose) {
            out.println();
        }
        out.println(String.format("Total %d tests (Passed: %d; Fails: %d; Errors: %d) (%.2f ms)", this.totalPasses.get() + this.totalFails.get() + this.totalErrors.get(), this.totalPasses.get(), this.totalFails.get(), this.totalErrors.get(), Float.valueOf(this.findMaxTime())));
    }

    private void printBrowserSummary(PrintStream out, String browser, RunData data) {
        out.println(String.format("  %s: Run %d tests (Passed: %d; Fails: %d; Errors %d) (%.2f ms)", browser, data.getPassed() + data.getFailed() + data.getErrors(), data.getPassed(), data.getFailed(), data.getErrors(), Float.valueOf(data.getTotalTime())));
    }

    private float findMaxTime() {
        float max = 0.0f;
        for (RunData data : this.browsersRunData.values()) {
            max = Math.max(data.getTotalTime(), max);
        }
        return max;
    }

    public void onTestComplete(TestResult testResult) {
        String browser = testResult.getBrowserInfo().toString();
        RunData runData = this.currentRunData(browser);
        TestResult.Result result = testResult.getResult();
        String log = testResult.getLog();
        runData.addTime(testResult.getTime());
        if (result == TestResult.Result.passed) {
            if (!this.verbose) {
                this.out.print('.');
                if (log.length() > 0) {
                    runData.addProblem(new TestResultProblem(testResult));
                }
            } else {
                this.printInProgress("[PASSED] ", testResult, log);
            }
            runData.addPass();
            this.totalPasses.incrementAndGet();
        } else if (result == TestResult.Result.failed) {
            if (!this.verbose) {
                this.out.print('F');
            } else {
                this.printInProgress("[FAILED] ", testResult, log);
            }
            runData.addFail();
            runData.addProblem(new TestResultProblem(testResult));
            this.totalFails.incrementAndGet();
        } else if (result == TestResult.Result.error) {
            if (!this.verbose) {
                this.out.print('E');
            } else {
                this.printInProgress("[ERROR] ", testResult, log);
            }
            runData.addError();
            runData.addProblem(new TestResultProblem(testResult));
            this.totalErrors.incrementAndGet();
        } else {
            this.out.print("<" + (Object)((Object)result) + ">");
            if (this.verbose) {
                this.out.println(" " + testResult.getTestCaseName() + "." + testResult.getTestName());
                if (log.length() > 0) {
                    String[] logLines;
                    for (String line : logLines = log.split("\n")) {
                        this.out.println("  " + line);
                    }
                }
            }
            runData.addProblem(new TestResultProblem(testResult));
        }
        if (this.lineColumn.incrementAndGet() == this.lineLength) {
            this.out.println();
            this.lineColumn.set(0);
        }
    }

    private void printInProgress(String type, TestResult testResult, String log) {
        this.out.println(type + testResult.getTestCaseName() + "." + testResult.getTestName());
        if (log.length() > 0) {
            String[] logLines;
            for (String line : logLines = log.split("\n")) {
                this.out.println("  " + line);
            }
        }
    }

    private synchronized RunData currentRunData(String browser) {
        RunData runData = this.browsersRunData.get(browser);
        if (runData == null) {
            runData = new RunData();
            this.browsersRunData.put(browser, runData);
        }
        return runData;
    }

    public void onFileLoad(String browser, FileResult fileResult) {
        if (fileResult.isSuccess()) {
            if (this.verbose) {
                this.out.println(browser + " loaded " + fileResult.getFileSource().getFileSrc());
            }
            return;
        }
        RunData runData = this.currentRunData(browser);
        runData.addError();
        runData.addProblem(new FileLoadProblem(fileResult));
        if (this.verbose) {
            this.out.println("[ERROR] " + fileResult.getMessage());
        }
    }
}

