/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.html;

import com.google.jstestdriver.html.HtmlDocNode;
import com.google.jstestdriver.html.HtmlDocNodeFactory;
import com.google.jstestdriver.token.EscapingWriter;
import com.google.jstestdriver.token.Node;
import com.google.jstestdriver.token.Token;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlDocNestedNode
extends HtmlDocNode {
    private static final char[] JS_END_STATEMENT = "window.document);".toCharArray();
    private static final char[] JS_ARG_SEP = "',".toCharArray();
    private static final char[] JS_THIS = "this.".toCharArray();
    private static final char[] JS_TO_HTML = " = jstestdriver.toHtml('".toCharArray();
    private static final char[] JS_APPEND_HTML = "jstestdriver.appendHtml('".toCharArray();

    public HtmlDocNestedNode(Token id, List<Token> tokens) {
        super(id, tokens);
    }

    @Override
    public void write(Writer writer) {
        EscapingWriter escaping = new EscapingWriter(writer);
        try {
            if (this.id.contains('+')) {
                writer.write(JS_APPEND_HTML);
            } else {
                writer.write(JS_THIS);
                this.id.write(escaping);
                writer.write(JS_TO_HTML);
            }
            for (Token fragment : this.html) {
                fragment.write(escaping);
            }
            writer.write(JS_ARG_SEP);
            writer.write(JS_END_STATEMENT);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NestedNodeStrategy
    implements HtmlDocNodeFactory.CreateNodeStrategy {
        @Override
        public Node create(Token id, List<Token> html) {
            return new HtmlDocNestedNode(id, html);
        }
    }
}

