/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.jstestdriver.DefaultResponseStreamFactory;
import com.google.jstestdriver.Flags;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.config.Configuration;
import com.google.jstestdriver.hooks.PluginInitializer;
import com.google.jstestdriver.output.DefaultListener;
import com.google.jstestdriver.output.MultiTestResultListener;
import com.google.jstestdriver.output.TestResultHolder;
import com.google.jstestdriver.output.TestResultListener;

public class TestResultPrintingModule
extends AbstractModule {
    private final String testOutput;

    public TestResultPrintingModule(String testOutput) {
        this.testOutput = testOutput;
    }

    protected void configure() {
        Multibinder<TestResultListener> testResultListeners = Multibinder.newSetBinder(this.binder(), TestResultListener.class);
        if (this.testOutput.length() > 0) {
            testResultListeners.addBinding().to(TestResultHolder.class).in(Singleton.class);
        }
        testResultListeners.addBinding().to(DefaultListener.class).in(Singleton.class);
        this.bind(TestResultListener.class).to(MultiTestResultListener.class);
        Multibinder.newSetBinder(this.binder(), ResponseStreamFactory.class).addBinding().to(DefaultResponseStreamFactory.class);
    }

    public static class TestResultPrintingInitializer
    implements PluginInitializer {
        public Module initializeModule(Flags flags, Configuration config) {
            return new TestResultPrintingModule(flags.getTestOutput());
        }
    }
}

