/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.config;

import com.google.common.collect.Lists;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.Plugin;
import com.google.jstestdriver.config.Configuration;
import com.google.jstestdriver.config.ParsedConfiguration;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jvyaml.YAML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlParser {
    public Configuration parse(Reader configReader) {
        Map data = (Map)YAML.load(configReader);
        LinkedHashSet<FileInfo> resolvedFilesLoad = new LinkedHashSet<FileInfo>();
        LinkedHashSet<FileInfo> resolvedFilesExclude = new LinkedHashSet<FileInfo>();
        String server = "";
        long timeOut = 0L;
        LinkedList<Plugin> plugins = Lists.newLinkedList();
        if (data.containsKey("load")) {
            resolvedFilesLoad.addAll(this.createFileInfos((List)data.get("load"), false));
        }
        if (data.containsKey("exclude")) {
            resolvedFilesExclude.addAll(this.createFileInfos((List)data.get("exclude"), false));
        }
        if (data.containsKey("server")) {
            server = (String)data.get("server");
        }
        if (data.containsKey("plugin")) {
            for (Map value : (List)data.get("plugin")) {
                plugins.add(new Plugin((String)value.get("name"), (String)value.get("jar"), (String)value.get("module"), this.createArgsList((String)value.get("args"))));
            }
        }
        if (data.containsKey("serve")) {
            Set<FileInfo> resolvedServeFiles = this.createFileInfos((List)data.get("serve"), true);
            resolvedFilesLoad.addAll(resolvedServeFiles);
        }
        if (data.containsKey("timeout")) {
            timeOut = (Long)data.get("timeout");
        }
        return new ParsedConfiguration(resolvedFilesLoad, resolvedFilesExclude, plugins, server, timeOut);
    }

    private List<String> createArgsList(String args) {
        String[] splittedArgs;
        if (args == null) {
            return Collections.emptyList();
        }
        LinkedList<String> argsList = Lists.newLinkedList();
        for (String arg : splittedArgs = args.split(",")) {
            argsList.add(arg.trim());
        }
        return argsList;
    }

    private Set<FileInfo> createFileInfos(List<String> files, boolean serveOnly) {
        if (files != null) {
            LinkedHashSet<FileInfo> fileInfos = new LinkedHashSet<FileInfo>();
            for (String f : files) {
                boolean isPatch = f.startsWith("patch");
                if (isPatch) {
                    String[] tokens = f.split(" ", 2);
                    f = tokens[1].trim();
                }
                fileInfos.add(new FileInfo(f, -1L, isPatch, serveOnly, null));
            }
            return fileInfos;
        }
        return Collections.emptySet();
    }
}

