/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.config;

import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.PathResolver;
import com.google.jstestdriver.Plugin;
import com.google.jstestdriver.config.Configuration;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvedConfiguration
implements Configuration {
    private final Set<FileInfo> filesList;
    private final List<Plugin> plugins;
    private final String server;
    private final long testSuiteTimeout;

    public ResolvedConfiguration(Set<FileInfo> filesList, List<Plugin> plugins, String server, long testSuiteTimeout) {
        this.filesList = filesList;
        this.plugins = plugins;
        this.server = server;
        this.testSuiteTimeout = testSuiteTimeout;
    }

    @Override
    public String createServerAddress(String flagValue, int port) {
        if (flagValue != null && flagValue.length() != 0) {
            return flagValue;
        }
        if (this.server.length() > 0) {
            return this.server;
        }
        if (port == -1) {
            throw new RuntimeException("Oh Snap! No server defined!");
        }
        return String.format("http://%s:%d", "127.0.0.1", port);
    }

    @Override
    public Set<FileInfo> getFilesList() {
        return this.filesList;
    }

    @Override
    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    @Override
    public Configuration resolvePaths(PathResolver resolver) {
        return this;
    }

    @Override
    public long getTestSuiteTimeout() {
        return this.testSuiteTimeout > 0L ? this.testSuiteTimeout : 7200L;
    }
}

