/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.config;

import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.PathResolver;
import com.google.jstestdriver.Plugin;
import com.google.jstestdriver.config.Configuration;
import com.google.jstestdriver.config.ResolvedConfiguration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedConfiguration
implements Configuration {
    private final Set<FileInfo> filesList;
    private final String server;
    private final List<Plugin> plugins;
    private final Set<FileInfo> excludedFiles;
    private final long testTimeout;

    public ParsedConfiguration(Set<FileInfo> filesList, Set<FileInfo> excludedFiles, List<Plugin> plugins, String server, long testTimeout) {
        this.filesList = filesList;
        this.excludedFiles = excludedFiles;
        this.plugins = plugins;
        this.server = server;
        this.testTimeout = testTimeout;
    }

    @Override
    public Set<FileInfo> getFilesList() {
        LinkedHashSet<FileInfo> finalList = new LinkedHashSet<FileInfo>(this.filesList);
        finalList.removeAll(this.excludedFiles);
        return finalList;
    }

    @Override
    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    @Override
    public String createServerAddress(String flagValue, int port) {
        if (flagValue != null && flagValue.length() != 0) {
            return flagValue;
        }
        if (this.server.length() > 0) {
            return this.server;
        }
        if (port == -1) {
            throw new RuntimeException("Oh Snap! No server defined!");
        }
        return String.format("http://%s:%d", "127.0.0.1", port);
    }

    @Override
    public Configuration resolvePaths(PathResolver resolver) {
        Set<FileInfo> resolvedFiles = resolver.resolve(this.filesList);
        Set<FileInfo> resolvedExcluded = resolver.resolve(this.excludedFiles);
        resolvedFiles.removeAll(resolvedExcluded);
        return new ResolvedConfiguration(resolvedFiles, resolver.resolve(this.plugins), this.server, this.testTimeout);
    }

    @Override
    public long getTestSuiteTimeout() {
        return this.testTimeout;
    }
}

