/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.config;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.jstestdriver.Plugin;
import com.google.jstestdriver.config.CmdLineFlag;
import com.google.jstestdriver.runner.RunnerMode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdFlags {
    private static final Set<String> PREPARSE_FLAGS = ImmutableSet.of(new String[]{"--plugins", "--config", "--basePath", "--runnerMode"});
    private final List<CmdLineFlag> flags;

    public CmdFlags(List<CmdLineFlag> flags) {
        this.flags = flags;
    }

    public List<Plugin> getPlugins() throws IOException {
        for (CmdLineFlag cmdLineFlag : this.flags) {
            if (!"--plugins".equals(cmdLineFlag.flag)) continue;
            LinkedList<Plugin> plugins = Lists.newLinkedList();
            for (String pluginPath : cmdLineFlag.valuesList()) {
                plugins.add(new Plugin(null, new File(this.getBasePath(), pluginPath).getAbsolutePath(), null, Collections.<String>emptyList()));
            }
            return plugins;
        }
        return Collections.emptyList();
    }

    private String getConfigPathNoDefault() {
        for (CmdLineFlag cmdLineFlag : this.flags) {
            if (!"--config".equals(cmdLineFlag.flag)) continue;
            return cmdLineFlag.safeValue();
        }
        return null;
    }

    private String getBasePathNoDefault() throws IOException {
        for (CmdLineFlag cmdLineFlag : this.flags) {
            if (!"--basePath".equals(cmdLineFlag.flag)) continue;
            return new File(cmdLineFlag.safeValue()).getCanonicalPath();
        }
        return null;
    }

    public File getConfigPath() throws IOException {
        File defaultConfig;
        String configPath = this.getConfigPathNoDefault();
        String basePath = this.getBasePathNoDefault();
        File file = defaultConfig = basePath == null ? new File("jsTestDriver.conf") : new File(new File(basePath), "jsTestDriver.conf");
        if (configPath == null) {
            return defaultConfig.exists() ? defaultConfig : null;
        }
        return basePath == null ? new File(configPath) : new File(new File(basePath), configPath);
    }

    public File getBasePath() throws IOException {
        String basePath = this.getBasePathNoDefault();
        if (basePath != null) {
            return new File(basePath);
        }
        String configPath = this.getConfigPathNoDefault();
        if (configPath == null) {
            return new File(".").getCanonicalFile();
        }
        File parentFile = new File(configPath).getParentFile();
        if (parentFile != null) {
            return parentFile.getCanonicalFile();
        }
        return new File(".").getCanonicalFile();
    }

    public RunnerMode getRunnerMode() {
        for (CmdLineFlag cmdLineFlag : this.flags) {
            if (!"--runnerMode".equals(cmdLineFlag.flag)) continue;
            return RunnerMode.valueOf(cmdLineFlag.safeValue());
        }
        return RunnerMode.QUIET;
    }

    public String[] getUnusedFlagsAsArgs() {
        ArrayList<String> args = Lists.newArrayList();
        for (CmdLineFlag flag : this.flags) {
            if (PREPARSE_FLAGS.contains(flag.flag)) continue;
            flag.addToArgs(args);
        }
        return args.toArray(new String[args.size()]);
    }
}

