/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.browser;

import com.google.jstestdriver.ProcessFactory;
import com.google.jstestdriver.browser.BrowserRunner;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineBrowserRunner
implements BrowserRunner {
    private static final Logger logger = LoggerFactory.getLogger(CommandLineBrowserRunner.class);
    private final String browserPath;
    private final ProcessFactory processFactory;
    private Process process;

    public CommandLineBrowserRunner(String browserPath, ProcessFactory processFactory) {
        this.browserPath = browserPath;
        this.processFactory = processFactory;
    }

    public void startBrowser(String serverAddress) {
        try {
            this.process = this.processFactory.start(this.browserPath, serverAddress);
        }
        catch (IOException e) {
            logger.error("Could not start: {} because {}", (Object)this.browserPath, (Object)e.toString());
            throw new RuntimeException(e);
        }
    }

    public void stopBrowser() {
        try {
            this.process.destroy();
            if (this.process.exitValue() != 0) {
                logger.warn("Unexpected shutdown " + this.process + " " + this.process.exitValue());
            }
        }
        catch (IllegalThreadStateException e) {
            logger.warn("Process refused to exit" + this.process);
        }
    }

    public int getTimeout() {
        return 30;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.browserPath == null ? 0 : this.browserPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandLineBrowserRunner)) {
            return false;
        }
        CommandLineBrowserRunner other = (CommandLineBrowserRunner)obj;
        return !(this.browserPath == null ? other.browserPath != null : !this.browserPath.equals(other.browserPath));
    }

    public String toString() {
        return "CommandLineBrowserRunner [browserPath=" + this.browserPath + ", process=" + this.process + ", processFactory=" + this.processFactory + "]";
    }
}

