/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.browser;

import com.google.jstestdriver.BrowserActionRunner;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.browser.BrowserRunner;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserManagedRunner
implements Callable<ResponseStream> {
    private static final Logger logger = LoggerFactory.getLogger(BrowserManagedRunner.class);
    private final BrowserRunner runner;
    private final String browserId;
    private final BrowserActionRunner browserActionRunner;
    private final String serverAddress;
    private final JsTestDriverClient client;

    public BrowserManagedRunner(BrowserRunner runner, String browserId, String serverAddress, JsTestDriverClient client, BrowserActionRunner browserActionRunner) {
        this.runner = runner;
        this.browserId = browserId;
        this.serverAddress = serverAddress;
        this.client = client;
        this.browserActionRunner = browserActionRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseStream call() throws Exception {
        String url = String.format("%s/capture?id=%s", this.serverAddress, this.browserId);
        this.runner.startBrowser(url);
        try {
            long timeOut = TimeUnit.MILLISECONDS.convert(this.runner.getTimeout(), TimeUnit.SECONDS);
            long start = System.currentTimeMillis();
            while (!this.isBrowserCaptured(this.browserId, this.client)) {
                Thread.sleep(50L);
                if (System.currentTimeMillis() - start <= timeOut) continue;
                throw new RuntimeException("Could not start browser " + this.runner + " in " + this.runner.getTimeout());
            }
            ResponseStream responseStream = this.browserActionRunner.call();
            return responseStream;
        }
        finally {
            this.runner.stopBrowser();
        }
    }

    private boolean isBrowserCaptured(String browserId, JsTestDriverClient client) {
        for (BrowserInfo browserInfo : client.listBrowsers()) {
            if (!browserId.equals(String.valueOf(browserInfo.getId()))) continue;
            logger.debug("Started {}", browserInfo);
            return true;
        }
        return false;
    }
}

