/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.google.inject.name.Named;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.FailureParser;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.TestResult;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResultGenerator {
    private static String NEW_LINE = System.getProperty("line.separator");
    private final Gson gson = new Gson();
    private final FailureParser failureParser = new FailureParser();
    private final File basePath;

    public TestResultGenerator(@Named(value="basePath") File basePath) {
        this.basePath = basePath;
    }

    @Deprecated
    public TestResultGenerator() {
        this.basePath = new File("");
    }

    public Collection<TestResult> getTestResults(Response response) {
        try {
            String basePathString = this.basePath.getCanonicalPath();
            if (response.getResponseType() != Response.ResponseType.TEST_RESULT) {
                return Collections.emptyList();
            }
            Collection results = (Collection)this.gson.fromJson(response.getResponse(), new TypeToken<Collection<TestResult>>(){}.getType());
            for (TestResult result : results) {
                BrowserInfo browserInfo = response.getBrowser();
                result.setBrowserInfo(browserInfo);
                FailureParser.Failure failure = this.failureParser.parse(result.getMessage());
                result.setParsedMessage(failure.getMessage());
                List<String> stackTrace = failure.getStack();
                StringBuilder sb = new StringBuilder();
                Iterator<String> i$ = stackTrace.iterator();
                while (i$.hasNext()) {
                    String l;
                    int offset = (l = i$.next()).indexOf(basePathString);
                    sb.append(l.substring(offset > -1 ? offset + basePathString.length() : 0));
                    sb.append(NEW_LINE);
                }
                result.setStack(sb.toString());
            }
            return results;
        }
        catch (JsonParseException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

