/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.jstestdriver.BrowserHunter;
import com.google.jstestdriver.FileSource;
import com.google.jstestdriver.FilesCache;
import com.google.jstestdriver.JsonCommand;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.SlaveResourceService;
import com.google.jstestdriver.SlaveResourceServlet;
import com.google.jstestdriver.StandaloneRunnerFilesFilter;
import com.google.jstestdriver.UserAgentParser;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StandaloneRunnerServlet
extends HttpServlet {
    private static final long serialVersionUID = 8525889760512657635L;
    private final Gson gson = new Gson();
    private final BrowserHunter browserHunter;
    private final FilesCache cache;
    private final StandaloneRunnerFilesFilter filter;
    private final SlaveResourceService service;
    private static final Pattern ID = Pattern.compile("/(\\d+)/.*");

    public StandaloneRunnerServlet(BrowserHunter browserHunter, FilesCache cache, StandaloneRunnerFilesFilter filter, SlaveResourceService service) {
        this.browserHunter = browserHunter;
        this.cache = cache;
        this.filter = filter;
        this.service = service;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path = SlaveResourceServlet.stripId(req.getPathInfo());
        String id = StandaloneRunnerServlet.getIdFromUrl(req.getPathInfo());
        if (req.getPathInfo().endsWith("RemoteConsoleRunnerquirks.html") || req.getPathInfo().endsWith("RemoteConsoleRunnerstrict.html")) {
            if (this.browserHunter.isBrowserCaptured(id)) {
                this.browserHunter.freeBrowser(id);
            }
            this.service(req.getHeader("User-Agent"), path, id);
        }
        this.service.serve(path, resp.getOutputStream());
    }

    public static String getIdFromUrl(String pathInfo) {
        Matcher match = ID.matcher(pathInfo);
        if (match.find()) {
            return match.group(1);
        }
        throw new IllegalArgumentException(pathInfo);
    }

    public void service(String userAgent, String path, String id) {
        UserAgentParser parser = new UserAgentParser();
        parser.parse(userAgent);
        SlaveBrowser slaveBrowser = this.browserHunter.captureBrowser(id, parser.getName(), parser.getVersion(), parser.getOs());
        Set<String> filesToload = this.filter.filter(path, this.cache);
        LinkedList<FileSource> filesSources = new LinkedList<FileSource>();
        for (String f : filesToload) {
            filesSources.add(new FileSource("/test/" + f, -1L));
        }
        int size = filesSources.size();
        for (int i = 0; i < size; i += 50) {
            LinkedList<String> loadFilesParameters = new LinkedList<String>();
            List chunkedFileSources = filesSources.subList(i, Math.min(i + 50, size));
            loadFilesParameters.add(this.gson.toJson(chunkedFileSources));
            loadFilesParameters.add("true");
            slaveBrowser.createCommand(this.gson.toJson(new JsonCommand(JsonCommand.CommandType.LOADTEST, loadFilesParameters)));
        }
        LinkedList<String> runAllTestsParameters = new LinkedList<String>();
        runAllTestsParameters.add("false");
        runAllTestsParameters.add("true");
        slaveBrowser.createCommand(this.gson.toJson(new JsonCommand(JsonCommand.CommandType.RUNALLTESTS, runAllTestsParameters)));
    }
}

